/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.nlp;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import company.evo.jmorphy2.nlp.Node;
import company.evo.jmorphy2.nlp.Rule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ruleset {
    private final List<Rule> rules = new ArrayList<Rule>();
    private final Map<Integer, List<Rule>> rulesBySize = new HashMap<Integer, List<Rule>>();
    private int maxRightSize;
    private static final String COMMENT_START = "#";
    private static final String CONTINUE_LINE = "\\";
    private static final String PARTS_SPLITTER = "->";
    private static final String RHS_SPLITTER = "|";
    private static final String WEIGHT_START = "[";
    private static final String WEIGHT_END = "]";
    private static final Splitter partsSplitter = Splitter.on((String)"->").limit(2).trimResults();
    private static final Splitter rhsSplitter = Splitter.on((String)"|").trimResults();
    private static final Pattern rhsPattern = Pattern.compile(String.format("^(?<rhs>.+)\\%s(?<weight>.+)\\%s$", "[", "]"));

    public Ruleset() {
    }

    public Ruleset(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String row = "";
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith(COMMENT_START)) continue;
            if ((row = row + line).endsWith(CONTINUE_LINE)) {
                row = row.substring(0, row.length() - 1);
                continue;
            }
            ArrayList parts = Lists.newArrayList((Iterable)partsSplitter.split((CharSequence)row));
            if (parts.size() < 2) {
                throw new RuntimeException("Left or right part is missing");
            }
            String leftPart = (String)parts.get(0);
            String rightPart = (String)parts.get(1);
            Matcher rhsMatcher = rhsPattern.matcher(rightPart);
            if (rhsMatcher.matches()) {
                float weight = Float.parseFloat(rhsMatcher.group("weight"));
                this.add(leftPart, rhsMatcher.group("rhs").trim(), weight);
            } else {
                this.add(leftPart, rightPart);
            }
            row = "";
        }
    }

    public void add(String left, String right) {
        this.add(left, right, 1.0f);
    }

    public void add(String left, String right, float weight) {
        for (String rightPart : rhsSplitter.split((CharSequence)right)) {
            Rule r = new Rule(left, rightPart, weight);
            this.rules.add(r);
            List<Rule> bySize = this.rulesBySize.get(r.rightSize);
            if (bySize == null) {
                bySize = new ArrayList<Rule>();
                this.rulesBySize.put(r.rightSize, bySize);
            }
            bySize.add(r);
            if (r.rightSize <= this.maxRightSize) continue;
            this.maxRightSize = r.rightSize;
        }
    }

    public int getMaxRightSize() {
        return this.maxRightSize;
    }

    public Rule match(List<Node> nodes) {
        List<Rule> testRules = this.rulesBySize.get(nodes.size());
        if (testRules == null) {
            return null;
        }
        for (Rule rule : testRules) {
            if (!rule.match(nodes)) continue;
            return rule;
        }
        return null;
    }

    public List<Rule> matchAll(List<Node> nodes) {
        ArrayList<Rule> matchedRules = new ArrayList<Rule>();
        List<Rule> testRules = this.rulesBySize.get(nodes.size());
        if (testRules == null) {
            return matchedRules;
        }
        for (Rule rule : testRules) {
            if (!rule.match(nodes)) continue;
            matchedRules.add(rule);
        }
        return matchedRules;
    }

    public String toString() {
        return Joiner.on((String)"\n").join(this.rules);
    }
}

