/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.security.SecureRandom;

public class PRNG {
    private static PRNG _prng = null;
    private SecureRandom _sr;

    private PRNG() {
    }

    private PRNG(SecureRandom secureRandom) {
        this._sr = secureRandom;
    }

    public static void init(SecureRandom secureRandom) {
        if (_prng == null) {
            _prng = new PRNG(secureRandom);
        }
    }

    public static PRNG getInstance() {
        if (_prng == null) {
            PRNG.init(new SecureRandom());
        }
        return _prng;
    }

    public SecureRandom getSecureRandom() {
        return this._sr;
    }

    public static byte[] createBytes(int n) {
        byte[] byArray = new byte[n];
        PRNG.getInstance().nextBytes(byArray);
        return byArray;
    }

    public void nextBytes(byte[] byArray) {
        this._sr.nextBytes(byArray);
    }

    public double nextDouble() {
        return this._sr.nextDouble();
    }

    public int nextInt() {
        return this._sr.nextInt();
    }

    public int nextInt(int n) {
        return this._sr.nextInt(n);
    }

    public boolean nextBoolean() {
        return this._sr.nextBoolean();
    }
}

