/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogContext;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DeletedDupLNLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.WriteLockInfo;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class LN
extends Node
implements Loggable {
    private static final String BEGIN_TAG = "<ln>";
    private static final String END_TAG = "</ln>";
    private byte[] data;
    private static final int DIRTY_BIT = Integer.MIN_VALUE;
    private static final int CLEAR_DIRTY_BIT = Integer.MAX_VALUE;
    private static final int LAST_LOGGED_SIZE_MASK = Integer.MAX_VALUE;
    private static final int CLEAR_LAST_LOGGED_SIZE = Integer.MIN_VALUE;
    private int flags;

    public LN() {
        this.data = null;
    }

    public LN(byte[] data, EnvironmentImpl envImpl, boolean replicated) {
        super(envImpl, replicated);
        if (data == null) {
            this.data = null;
        } else {
            this.init(data, 0, data.length);
        }
        this.setDirty();
    }

    public LN(DatabaseEntry dbt, EnvironmentImpl envImpl, boolean replicated) {
        super(envImpl, replicated);
        byte[] dat = dbt.getData();
        if (dat == null) {
            this.data = null;
        } else if (dbt.getPartial()) {
            this.init(dat, dbt.getOffset(), dbt.getPartialOffset() + dbt.getSize(), dbt.getPartialOffset(), dbt.getSize());
        } else {
            this.init(dat, dbt.getOffset(), dbt.getSize());
        }
        this.setDirty();
    }

    private void init(byte[] data, int off, int len, int doff, int dlen) {
        if (len == 0) {
            this.data = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        } else {
            this.data = new byte[len];
            System.arraycopy(data, off, this.data, doff, dlen);
        }
    }

    private void init(byte[] data, int off, int len) {
        this.init(data, off, len, 0, len);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] copyData() {
        int len = this.data.length;
        byte[] ret = new byte[len];
        System.arraycopy(this.data, 0, ret, 0, len);
        return ret;
    }

    public boolean isDeleted() {
        return this.data == null;
    }

    void makeDeleted() {
        this.data = null;
    }

    public boolean isDirty() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    public void setDirty() {
        this.flags |= Integer.MIN_VALUE;
    }

    private void clearDirty() {
        this.flags &= Integer.MAX_VALUE;
    }

    boolean isValidForDelete() {
        return false;
    }

    boolean isEvictableInexact() {
        return true;
    }

    boolean isEvictable() throws DatabaseException {
        return true;
    }

    protected boolean isSoughtNode(long nid, CacheMode cacheMode, boolean ignore) {
        return false;
    }

    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return false;
    }

    public long delete(DatabaseImpl database, byte[] lnKey, byte[] dupKey, long oldLsn, Locker locker, ReplicationContext repContext) throws DatabaseException {
        if (database.getSortedDuplicates() && dupKey == null) {
            dupKey = lnKey;
            lnKey = this.data;
        }
        this.makeDeleted();
        this.setDirty();
        EnvironmentImpl env = database.getDbEnvironment();
        long newLsn = -1L;
        if (dupKey != null) {
            if (database.isDeferredWriteMode() && oldLsn == -1L) {
                this.clearDirty();
            } else {
                newLsn = this.log(env, database, lnKey, dupKey, oldLsn, locker, false, false, repContext);
            }
        } else {
            newLsn = this.optionalLog(env, database, lnKey, oldLsn, locker, repContext);
        }
        return newLsn;
    }

    public long modify(byte[] newData, DatabaseImpl database, byte[] lnKey, long oldLsn, Locker locker, ReplicationContext repContext) throws DatabaseException {
        this.data = newData;
        this.setDirty();
        EnvironmentImpl env = database.getDbEnvironment();
        long newLsn = this.optionalLog(env, database, lnKey, oldLsn, locker, repContext);
        return newLsn;
    }

    void rebuildINList(INList inList) {
    }

    void accountForSubtreeRemoval(INList inList, LocalUtilizationTracker localTracker) {
    }

    public long getMemorySizeIncludedByParent() {
        int size = MemoryBudget.LN_OVERHEAD;
        if (this.data != null) {
            size += MemoryBudget.byteArraySize(this.data.length);
        }
        return size;
    }

    public void releaseMemoryBudget() {
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer self = new StringBuffer();
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.beginTag());
            self.append('\n');
        }
        self.append(super.dumpString(nSpaces + 2, true));
        self.append('\n');
        if (this.data != null) {
            self.append(TreeUtils.indent(nSpaces + 2));
            self.append("<data>");
            self.append(Key.DUMP_TYPE.dumpByteArray(this.data));
            self.append("</data>");
            self.append('\n');
        }
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.endTag());
        }
        return self.toString();
    }

    public long log(EnvironmentImpl env, DatabaseImpl databaseImpl, byte[] key, long oldLsn, Locker locker, boolean backgroundIO, ReplicationContext repContext) throws DatabaseException {
        return this.log(env, databaseImpl, key, null, oldLsn, locker, backgroundIO, false, repContext);
    }

    public long optionalLog(EnvironmentImpl env, DatabaseImpl databaseImpl, byte[] key, long oldLsn, Locker locker, ReplicationContext repContext) throws DatabaseException {
        if (databaseImpl.isDeferredWriteMode()) {
            return -1L;
        }
        return this.log(env, databaseImpl, key, null, oldLsn, locker, false, false, repContext);
    }

    public long optionalLogProvisional(EnvironmentImpl env, DatabaseImpl databaseImpl, byte[] key, long oldLsn, ReplicationContext repContext) throws DatabaseException {
        if (databaseImpl.isDeferredWriteMode()) {
            return -1L;
        }
        return this.log(env, databaseImpl, key, null, oldLsn, null, false, true, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long log(EnvironmentImpl env, DatabaseImpl dbImpl, byte[] key, byte[] delDupKey, long oldLsn, Locker locker, boolean backgroundIO, boolean isProvisional, ReplicationContext repContext) throws DatabaseException {
        LogItem item;
        block15: {
            Txn logTxn;
            boolean logAbortKnownDeleted;
            long logAbortLsn;
            LogEntryType entryType;
            boolean isDelDup = delDupKey != null;
            LogContext context = new LogContext();
            if (locker != null && locker.isTransactional()) {
                entryType = isDelDup ? LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL : this.getTransactionalLogType();
                WriteLockInfo info = locker.getWriteLockInfo(this.getNodeId());
                logAbortLsn = info.getAbortLsn();
                logAbortKnownDeleted = info.getAbortKnownDeleted();
                logTxn = locker.getTxnLocker();
                assert (logTxn != null);
                if (oldLsn == logAbortLsn) {
                    info.setAbortInfo(dbImpl, this.getLastLoggedSize());
                }
                context.obsoleteDupsAllowed = locker.isRolledBack();
            } else {
                entryType = isDelDup ? LogEntryType.LOG_DEL_DUPLN : this.getLogType();
                logAbortLsn = -1L;
                logAbortKnownDeleted = false;
                logTxn = null;
            }
            if (oldLsn == logAbortLsn) {
                oldLsn = -1L;
            }
            if (dbImpl.isTemporary()) {
                isProvisional = true;
            }
            item = new LogItem();
            item.entry = this.createLogEntry(entryType, dbImpl, key, delDupKey, logAbortLsn, logAbortKnownDeleted, logTxn, repContext);
            item.provisional = isProvisional ? Provisional.YES : Provisional.NO;
            item.oldLsn = oldLsn;
            item.repContext = repContext;
            context.backgroundIO = backgroundIO;
            context.nodeDb = dbImpl;
            try {
                if (logTxn != null) {
                    Txn txn = logTxn;
                    synchronized (txn) {
                        env.getLogManager().log(item, context);
                        break block15;
                    }
                }
                env.getLogManager().log(item, context);
            }
            catch (DatabaseException e) {
                if (FileManager.continueAfterWriteException()) {
                    if (locker != null) {
                        new LNWriteFailureException(locker, e);
                    }
                    throw e;
                }
                if (env.isValid()) {
                    throw new EnvironmentFailureException(env, EnvironmentFailureReason.LOG_INCOMPLETE, "LN could not be logged", e);
                }
                throw e;
            }
        }
        this.clearDirty();
        return item.newLsn;
    }

    LNLogEntry createLogEntry(LogEntryType entryType, DatabaseImpl dbImpl, byte[] key, byte[] delDupKey, long logAbortLsn, boolean logAbortKnownDeleted, Txn logTxn, ReplicationContext repContext) {
        boolean isDelDup;
        DatabaseId dbId = dbImpl.getId();
        boolean bl = isDelDup = delDupKey != null;
        if (isDelDup) {
            return new DeletedDupLNLogEntry(entryType, this, dbId, delDupKey, key, logAbortLsn, logAbortKnownDeleted, logTxn);
        }
        return new LNLogEntry(entryType, this, dbId, key, logAbortLsn, logAbortKnownDeleted, logTxn);
    }

    public void incFetchStats(EnvironmentImpl envImpl, boolean isMiss) {
        envImpl.getEvictor().incLNFetchStats(isMiss);
    }

    protected LogEntryType getTransactionalLogType() {
        return LogEntryType.LOG_LN_TRANSACTIONAL;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_LN;
    }

    public int getLastLoggedSize() {
        return this.flags & Integer.MAX_VALUE;
    }

    public void setLastLoggedSize(int size) {
        this.flags = this.flags & Integer.MIN_VALUE | size;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        if (this.isDeleted()) {
            size += LogUtils.getPackedIntLogSize(-1);
        } else {
            int len = this.data.length;
            size += LogUtils.getPackedIntLogSize(len);
            size += len;
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        if (this.isDeleted()) {
            LogUtils.writePackedInt(logBuffer, -1);
        } else {
            LogUtils.writePackedInt(logBuffer, this.data.length);
            LogUtils.writeBytesNoLength(logBuffer, this.data);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        super.readFromLog(itemBuffer, entryVersion);
        if (entryVersion < 6) {
            boolean dataExists = LogUtils.readBoolean(itemBuffer);
            if (dataExists) {
                this.data = LogUtils.readByteArray(itemBuffer, true);
            }
        } else {
            int size = LogUtils.readInt(itemBuffer, false);
            if (size >= 0) {
                this.data = LogUtils.readBytesNoLength(itemBuffer, size);
            }
        }
    }

    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof LN)) {
            return false;
        }
        LN otherLN = (LN)other;
        if (this.getNodeId() != otherLN.getNodeId()) {
            return false;
        }
        return Arrays.equals(this.getData(), otherLN.getData());
    }

    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append(this.beginTag());
        super.dumpLog(sb, verbose);
        if (this.data != null) {
            sb.append("<data>");
            if (verbose) {
                sb.append(Key.DUMP_TYPE.dumpByteArray(this.data));
            } else {
                sb.append("hidden");
            }
            sb.append("</data>");
        }
        this.dumpLogAdditional(sb, verbose);
        sb.append(this.endTag());
    }

    public void dumpKey(StringBuilder sb, byte[] key) {
        sb.append(Key.dumpString(key, 0));
    }

    protected void dumpLogAdditional(StringBuilder sb, boolean verbose) {
    }

    static class LNWriteFailureException
    extends OperationFailureException {
        LNWriteFailureException(Locker locker, Exception cause) {
            super(locker, true, null, cause);
        }

        private LNWriteFailureException(String message, LNWriteFailureException cause) {
            super(message, cause);
        }

        public OperationFailureException wrapSelf(String msg) {
            return new LNWriteFailureException(msg, this);
        }
    }
}

