/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2;

import company.evo.dawg.PayloadsDAWG;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SuffixesDAWG
extends PayloadsDAWG {
    public SuffixesDAWG(InputStream stream) throws IOException {
        super(stream);
    }

    protected SuffixForm decodePayload(PayloadsDAWG.Payload payload) throws IOException {
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(payload.value));
        short count = stream.readShort();
        short paradigmId = stream.readShort();
        short idx = stream.readShort();
        return new SuffixForm(payload.key, count, paradigmId, idx);
    }

    public List<SuffixForm> similarSuffixes(String word, Map<Character, String> replaceChars) throws IOException {
        ArrayList<SuffixForm> foundSuffixes = new ArrayList<SuffixForm>();
        for (PayloadsDAWG.Payload payload : this.similarItems(word, replaceChars)) {
            foundSuffixes.add(this.decodePayload(payload));
        }
        return foundSuffixes;
    }

    public static class SuffixForm {
        public final String word;
        public final short count;
        public final short paradigmId;
        public final short idx;

        public SuffixForm(String word, short count, short paradigmId, short idx) {
            this.count = count;
            this.word = word;
            this.paradigmId = paradigmId;
            this.idx = idx;
        }

        public boolean equals(Object obj) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SuffixForm other = (SuffixForm)obj;
            return this.word.equals(other.word) && this.count == other.count && this.paradigmId == other.paradigmId && this.idx == other.idx;
        }
    }
}

