/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.RTimer;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.HttpCommComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchHandler
extends RequestHandlerBase
implements SolrCoreAware {
    static final String INIT_COMPONENTS = "components";
    static final String INIT_FIRST_COMPONENTS = "first-components";
    static final String INIT_LAST_COMPONENTS = "last-components";
    static final String INIT_SO_TIMEOUT = "shard-socket-timeout";
    static final String INIT_CONNECTION_TIMEOUT = "shard-connection-timeout";
    static int soTimeout = 0;
    static int connectionTimeout = 0;
    protected static Logger log = LoggerFactory.getLogger(SearchHandler.class);
    protected List<SearchComponent> components = null;

    protected List<String> getDefaultComponents() {
        ArrayList<String> names = new ArrayList<String>(6);
        names.add("query");
        names.add("facet");
        names.add("mlt");
        names.add("highlight");
        names.add("stats");
        names.add("debug");
        return names;
    }

    @Override
    public void inform(SolrCore core) {
        Object so;
        Object co;
        Object declaredComponents = this.initArgs.get(INIT_COMPONENTS);
        List first = (List)this.initArgs.get(INIT_FIRST_COMPONENTS);
        List last = (List)this.initArgs.get(INIT_LAST_COMPONENTS);
        List list = null;
        boolean makeDebugLast = true;
        if (declaredComponents == null) {
            list = this.getDefaultComponents();
            if (first != null) {
                List clist = first;
                clist.addAll(list);
                list = clist;
            }
            if (last != null) {
                list.addAll(last);
            }
        } else {
            list = (List)declaredComponents;
            if (first != null || last != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "First/Last components only valid if you do not declare 'components'");
            }
            makeDebugLast = false;
        }
        this.components = new ArrayList<SearchComponent>(list.size());
        DebugComponent dbgCmp = null;
        for (String c : list) {
            SearchComponent comp = core.getSearchComponent(c);
            if (comp instanceof DebugComponent && makeDebugLast) {
                dbgCmp = (DebugComponent)comp;
                continue;
            }
            this.components.add(comp);
            log.info("Adding  component:" + comp);
        }
        if (makeDebugLast && dbgCmp != null) {
            this.components.add(dbgCmp);
            log.info("Adding  debug component:" + dbgCmp);
        }
        if ((co = this.initArgs.get(INIT_CONNECTION_TIMEOUT)) != null) {
            connectionTimeout = (Integer)co;
            log.info("Setting shard-connection-timeout to: " + connectionTimeout);
        }
        if ((so = this.initArgs.get(INIT_SO_TIMEOUT)) != null) {
            soTimeout = (Integer)so;
            log.info("Setting shard-socket-timeout to: " + soTimeout);
        }
    }

    public List<SearchComponent> getComponents() {
        return this.components;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception, ParseException, InstantiationException, IllegalAccessException {
        RTimer subt;
        RTimer timer;
        ResponseBuilder rb = new ResponseBuilder();
        rb.req = req;
        rb.rsp = rsp;
        rb.components = this.components;
        rb.setDebug(req.getParams().getBool("debugQuery", false));
        RTimer rTimer = timer = rb.isDebug() ? new RTimer() : null;
        if (timer == null) {
            for (SearchComponent c : this.components) {
                c.prepare(rb);
            }
        } else {
            subt = timer.sub("prepare");
            for (SearchComponent c : this.components) {
                rb.setTimer(subt.sub(c.getName()));
                c.prepare(rb);
                rb.getTimer().stop();
            }
            subt.stop();
        }
        if (rb.shards == null) {
            if (!rb.isDebug()) {
                for (SearchComponent c : this.components) {
                    c.process(rb);
                }
            } else {
                subt = timer.sub("process");
                for (SearchComponent c : this.components) {
                    rb.setTimer(subt.sub(c.getName()));
                    c.process(rb);
                    rb.getTimer().stop();
                }
                subt.stop();
                timer.stop();
                if (rb.getDebugInfo() == null) {
                    rb.setDebugInfo((NamedList<Object>)new SimpleOrderedMap());
                }
                rb.getDebugInfo().add("timing", (Object)timer.asNamedList());
            }
        } else {
            HttpCommComponent comm = new HttpCommComponent();
            if (rb.outgoing == null) {
                rb.outgoing = new LinkedList<ShardRequest>();
            }
            rb.finished = new ArrayList<ShardRequest>();
            int nextStage = 0;
            do {
                rb.stage = nextStage;
                nextStage = ResponseBuilder.STAGE_DONE;
                for (SearchComponent c : this.components) {
                    nextStage = Math.min(nextStage, c.distributedProcess(rb));
                }
                while (rb.outgoing.size() > 0) {
                    ShardResponse srsp;
                    while (rb.outgoing.size() > 0) {
                        ShardRequest sreq = rb.outgoing.remove(0);
                        sreq.actualShards = sreq.shards;
                        if (sreq.actualShards == ShardRequest.ALL_SHARDS) {
                            sreq.actualShards = rb.shards;
                        }
                        sreq.responses = new ArrayList<ShardResponse>();
                        for (String shard : sreq.actualShards) {
                            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)sreq.params);
                            params.remove("shards");
                            params.remove("indent");
                            params.remove("echoParams");
                            params.set("isShard", true);
                            String shardHandler = req.getParams().get("shards.qt");
                            if (shardHandler == null) {
                                params.remove("qt");
                            } else {
                                params.set("qt", new String[]{shardHandler});
                            }
                            comm.submit(sreq, shard, params);
                        }
                    }
                    while (rb.outgoing.size() == 0 && (srsp = comm.takeCompletedOrError()) != null) {
                        if (srsp.getException() != null) {
                            comm.cancelAll();
                            if (srsp.getException() instanceof SolrException) {
                                throw (SolrException)srsp.getException();
                            }
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, srsp.getException());
                        }
                        rb.finished.add(srsp.getShardRequest());
                        for (SearchComponent c : this.components) {
                            c.handleResponses(rb, srsp.getShardRequest());
                        }
                    }
                }
                for (SearchComponent c : this.components) {
                    c.finishStage(rb);
                }
            } while (nextStage != Integer.MAX_VALUE);
        }
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search using components: ");
        if (this.components != null) {
            for (SearchComponent c : this.components) {
                sb.append(c.getName());
                sb.append(",");
            }
        }
        return sb.toString();
    }

    @Override
    public String getVersion() {
        return "$Revision: 1052938 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: SearchHandler.java 1052938 2010-12-26 20:21:48Z rmuir $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_3/solr/src/java/org/apache/solr/handler/component/SearchHandler.java $";
    }
}

