<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:java="http://xml.apache.org/xslt/java"
		xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
		xmlns:gslib="http://www.greenstone.org/skinning"
		xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"
		extension-element-prefixes="java util"
		exclude-result-prefixes="java util gsf">
  

  <!-- If the c parameter is empty then use the p.c parameter for the collection name-->
  <xsl:variable name="collNameChecked">
    <xsl:choose>
      <xsl:when test="$collName = '' and /page/pageRequest/paramList/param[@name='p.c']/@value">
	<xsl:value-of select="/page/pageRequest/paramList/param[@name='p.c']/@value"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="$collName"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="servletProtocol">
    <xsl:value-of select="/page/pageResponse/interfaceOptions/option[@name = 'servlet_protocol']/@value"/>
  </xsl:variable>
  <xsl:variable name="servletDomain">
    <xsl:value-of select="/page/pageResponse/interfaceOptions/option[@name = 'servlet_domain']/@value"/>
  </xsl:variable>
  <xsl:variable name="servletOptPort">
    <xsl:value-of select="/page/pageResponse/interfaceOptions/option[@name = 'servlet_opt_port']/@value"/>
  </xsl:variable>
  <xsl:variable name="servletContext">
    <xsl:value-of select="/page/pageResponse/interfaceOptions/option[@name = 'servlet_context']/@value"/>
  </xsl:variable>

  <!-- define this in a page xsl if you need args to be added to doc links -->
  <xsl:variable name="opt-doc-link-args"></xsl:variable>
</xsl:stylesheet>
