/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui.metaaudit;


import de.qfs.lib.gui.TableModelSorter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.greenstone.gatherer.metadata.MetadataAuditTableModel;

public class HeaderListener
    extends MouseAdapter {
    private MetaAuditFrame parent_frame;
    private MetaAuditTable table;
    public HeaderListener(MetaAuditFrame parent_frame, MetaAuditTable table) {
	this.parent_frame = parent_frame;
	this.table = table;
    }

    public void mouseClicked(MouseEvent event) {
	// Determine the column this was clicked on.
	int column = table.getColumnModel().getColumnIndexAtX(event.getX());
	int clicked_column = table.convertColumnIndexToModel(column);
	// Display the currently assigned filter.
	Filter filter_model = table.getFilter();
	Autofilter filter = filter_model.getFilter(clicked_column);
	MetadataAuditTableModel model = table.getOriginalModel();
	ArrayList default_values = model.getColumnValues(clicked_column);
	String column_name = model.getColumnName(clicked_column);
	filter = parent_frame.autofilter_dialog.display(filter, default_values, column_name);
	if(!parent_frame.autofilter_dialog.cancelled()) {
	    if(filter == null) {
		filter_model.clearFilter(clicked_column);
	    }
	    else {
		filter.setActive(true);
		TableModelSorter sorter = table.getSorter();
		sorter.setSortColumn(clicked_column);
		sorter.setSortAscending(filter.sort);
	    }
	    filter_model.fireFilterChanged();
	}
    }
}
