/**************************************************************************
 *
 * words.cpp -- Functions for parsing out words from the source text
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

// need this to avoid bizarre compiler problems under VC++ 6.0
#if defined (__WIN32__) && !defined (GSDL_USE_IOS_H)
# include <iostream>
#endif

#include "words.h"

int MAXNUMERIC = 4;

/* Takes the place of the old INAWORD macro. It determines
   whether a given place in a UTF-8 encoded Unicode string
   is part of a word. */
int inaword_mgpp (const u_char *here, const u_char *end) {
  unsigned short c;
  if (parse_utf8_char(here, end, &c) > 0) return is_unicode_letdig (c);
  return 0;
}

/* It determines whether a given place in a UTF-8 encoded Unicode string is a unicode space. */
int isaspace_mgpp (const u_char *here, const u_char *end)
{
  unsigned short c;
  if (parse_utf8_char(here, end, &c) > 0) return is_unicode_space(c);
  return 0;
}

/* Return a the UTF-8 encoded Unicode string with begining
   unicode spaces skippend. */
u_char *skipspace_mgpp(u_char *here, u_char *end)
{
  unsigned short c;	
  int length;
  while(here != end) {
    length = parse_utf8_char(here, end, &c);
    if (length == 0 || !is_unicode_space(c)) break;
    here += length;
  }
  return here;
}
 
const unsigned char *ParseIndexWord (const unsigned char *textHere,
				     const unsigned char *textEnd,
				     UCArray &word) {
  word.erase (word.begin(), word.end());

  register int charlength = 0;
  register int length = 0;
  register int numeric = 0;
  unsigned short c;
  
  charlength = parse_utf8_char (textHere, textEnd, &c);
  
  while (length+charlength <= MAXSTEMLEN && charlength > 0 &&
	 (is_unicode_letter(c) || (is_unicode_digit(c) &&
				   ++numeric <= MAXNUMERIC))) {
    while (charlength-- > 0) {
      word.push_back (*textHere++); ++length;
    }
    charlength = parse_utf8_char (textHere, textEnd, &c);
  }
  
  return textHere;
}

const unsigned char *ParseIndexMGWord (const unsigned char *textHere,
				       const unsigned char *textEnd,
				       unsigned char *mgWord) {
  register int charlength = 0;
  register int length = 0;
  register int numeric = 0;
  unsigned short c;
  
  charlength = parse_utf8_char (textHere, textEnd, &c);
  
  while (length+charlength <= MAXSTEMLEN && charlength > 0 &&
	 (is_unicode_letter(c) || (is_unicode_digit(c) &&
				   ++numeric <= MAXNUMERIC))) {
    while (charlength-- > 0) {
      mgWord[++length] = *textHere++;
    }
    charlength = parse_utf8_char (textHere, textEnd, &c);
  }

  mgWord[0] = length;
  
  return textHere;
}

const unsigned char *ParseNonindexWord (const unsigned char *textHere,
					const unsigned char *textEnd) {
  register int charlength = 0;
  unsigned short c;
  
  charlength = parse_utf8_char(textHere, textEnd, &c);
  
  while (charlength > 0 && !is_unicode_letdig(c)) {
    textHere += charlength;
    charlength = parse_utf8_char (textHere, textEnd, &c);
  }
  
  return textHere;
}
