/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.ArrayList;
import javax.swing.*;
import javax.swing.event.*;

import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.Dictionary;

public class SimpleResultDialog
  extends ModalDialog {
    
  private Dimension size = new Dimension(600,300);
  private SimpleResultDialog self;
    
  public SimpleResultDialog(String title, String label, String results) {
    super(Gatherer.g_man, title, true);
    this.self = this;
	this.setComponentOrientation(Dictionary.getOrientation());
        
    setUpGUI(label, results);
  }

  /** If you are calling this from another dialog, and you want that dialog blocked while this is open, need to use this method, passing in the calling dialog as the parent */
  public SimpleResultDialog(Dialog parent, String title, String label, String results) {

    super(parent, title, true);
    this.self = this;
  
    setUpGUI(label, results);
    TestingPreparation.setNamesRecursively(this);
  }

  private void setUpGUI(String label, String results) {
    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
    setSize(size);
	
    JPanel content_pane = (JPanel) getContentPane();
    content_pane.setComponentOrientation(Dictionary.getOrientation());
    JLabel result_label = new JLabel(label);
    result_label.setComponentOrientation(Dictionary.getOrientation());
	
    JPanel button_pane = new JPanel();
    button_pane.setComponentOrientation(Dictionary.getOrientation());
    JButton close_button = new GLIButton(Dictionary.get("General.Close"));
    close_button.addActionListener(new CloseButtonListener());
	
    JPanel output_pane = new JPanel();
    output_pane.setComponentOrientation(Dictionary.getOrientation());
    JLabel output_label = new JLabel(Dictionary.get("General.Review_Output"));
    output_label.setComponentOrientation(Dictionary.getOrientation());

    JTextArea output_textarea = new JTextArea(results);
    output_textarea.setComponentOrientation(Dictionary.getOrientation());
    output_textarea.setCaretPosition(0);
    output_textarea.setEditable(false);
    output_textarea.setLineWrap(true);
    output_textarea.setWrapStyleWord(true);
	
    button_pane.setLayout(new BorderLayout());
    button_pane.add(close_button, BorderLayout.LINE_END);
	
    output_pane.setBorder(BorderFactory.createEmptyBorder(5,0,5,0));
    output_pane.setLayout(new BorderLayout());
    output_pane.add(output_label, BorderLayout.NORTH);
    output_pane.add(new JScrollPane(output_textarea), BorderLayout.CENTER);
	
    content_pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
    content_pane.setLayout(new BorderLayout());
    content_pane.add(result_label, BorderLayout.NORTH);
    content_pane.add(output_pane, BorderLayout.CENTER);
    content_pane.add(button_pane, BorderLayout.SOUTH);
	
    // Position
    Rectangle frame_bounds = Gatherer.g_man.getBounds();
    setLocation(frame_bounds.x + (frame_bounds.width - size.width) / 2, frame_bounds.y + (frame_bounds.height - size.height) / 2);
    //new SimpleResultDialog(Gatherer.g_man, title, label, results);
  }
  
  
  private class CloseButtonListener
    implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      self.setVisible(false);
    }
  }
}
