package org.greenstone.gsdl3.auth.realm;

// log4j threw class-not-found exception => tomact not set up with this jar?
//import org.apache.log4j.Logger;
// so, work with java built-in version
import java.util.logging.Logger;

import org.apache.catalina.CredentialHandler;

import org.greenstone.gsdl3.util.AuthenticationHelper;


public class GreenstoneCredentialHandler implements CredentialHandler
{
    //static Logger logger = Logger.getLogger(GreenstoneCredentialHandler.class.getName());
    static Logger logger = Logger.getLogger(GreenstoneCredentialHandler.class.getName());
    
    // Consider rewriting this to use Log4J to be consistent with other files
    static {
	logger.info("GreenstoneCredentialHandler loaded");
    }


    @Override
    public boolean matches(String inputPassword, String storedHash)
    {
	System.err.println("**** GreenstoneCredentialHandler::matches() called with inputPassword='" + inputPassword + "', storedHash = '" + storedHash+"'");
	
	boolean input_matches = false;
	
        if (inputPassword != null && storedHash != null) {
	    
	    String hashed_input_password = AuthenticationHelper.hashPassword(inputPassword);
	    System.err.println("**** computed hash = '" + hashed_input_password + "'");
			       
	    input_matches = hashed_input_password.equals(storedHash);
	}

	System.err.println("**** Returning input_matches = " + input_matches);
	
	return input_matches;
	
    }

    @Override
    public String mutate(String inputPassword)
    {
	//System.err.println("**** GreenstoneCredentialHandler::mutate() - For future planning, method written but never used!");
	String hashed_input_password = AuthenticationHelper.hashPassword(inputPassword);

	System.err.println("**** inputPassword = " + inputPassword + ", hashed = " + hashed_input_password);
		
        return hashed_input_password;
    }
}
