/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.UnsupportedEncodingException;

public class Conversion {
    public static byte[] convertToByteArray(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new Error("Platform doesn't support UTF8 encoding");
        }
    }

    public static byte[] convertToByteArray(byte by) {
        by = (byte)(by ^ 0xFFFFFF80);
        return new byte[]{by};
    }

    public static byte[] convertToByteArray(short s) {
        s = (short)(s ^ Short.MIN_VALUE);
        byte[] byArray = new byte[2];
        Conversion.pack2(byArray, 0, s);
        return byArray;
    }

    public static byte[] convertToByteArray(int n) {
        byte[] byArray = new byte[4];
        Conversion.pack4(byArray, 0, n ^= Integer.MIN_VALUE);
        return byArray;
    }

    public static byte[] convertToByteArray(long l) {
        byte[] byArray = new byte[8];
        Conversion.pack8(byArray, 0, l ^= Long.MIN_VALUE);
        return byArray;
    }

    public static String convertToString(byte[] byArray) {
        try {
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new Error("Platform doesn't support UTF8 encoding");
        }
    }

    public static int convertToInt(byte[] byArray) {
        int n = Conversion.unpack4(byArray, 0);
        return n ^= Integer.MIN_VALUE;
    }

    public static long convertToLong(byte[] byArray) {
        long l = ((long)Conversion.unpack4(byArray, 0) << 32) + ((long)Conversion.unpack4(byArray, 4) & 0xFFFFFFFFL);
        return l ^= Long.MIN_VALUE;
    }

    static int unpack4(byte[] byArray, int n) {
        int n2 = byArray[n] << 24 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] << 0 & 0xFF;
        return n2;
    }

    static final void pack2(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)n2;
    }

    static final void pack4(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)n2;
    }

    static final void pack8(byte[] byArray, int n, long l) {
        Conversion.pack4(byArray, 0, (int)(l >> 32));
        Conversion.pack4(byArray, 4, (int)l);
    }

    public static void main(String[] stringArray) {
        byte[] byArray = Conversion.convertToByteArray(5);
        System.out.println("int value of 5 is: " + Conversion.convertToInt(byArray));
        byArray = Conversion.convertToByteArray(-1);
        System.out.println("int value of -1 is: " + Conversion.convertToInt(byArray));
        byArray = Conversion.convertToByteArray(22111000);
        System.out.println("int value of 22111000 is: " + Conversion.convertToInt(byArray));
        byArray = Conversion.convertToByteArray(5L);
        System.out.println("long value of 5 is: " + Conversion.convertToLong(byArray));
        byArray = Conversion.convertToByteArray(-1L);
        System.out.println("long value of -1 is: " + Conversion.convertToLong(byArray));
        byArray = Conversion.convertToByteArray(1112223334445556667L);
        System.out.println("long value of 1112223334445556667 is: " + Conversion.convertToLong(byArray));
    }
}

