/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.util.HashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class SetPropertiesRule
extends Rule {
    public SetPropertiesRule(Digester digester) {
        super(digester);
    }

    public void begin(Attributes attributes) throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            if ("".equals(name)) {
                name = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            if (this.digester.getDebug() >= 9) {
                this.digester.log("  Setting property '" + name + "' to '" + value + "'");
            }
            values.put(name, value);
            ++i;
        }
        Object top = this.digester.peek();
        if (this.digester.getDebug() >= 1) {
            this.digester.log("Set " + top.getClass().getName() + " properties");
        }
        BeanUtils.populate(top, values);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SetPropertiesRule[");
        sb.append("]");
        return sb.toString();
    }
}

