/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security.extension.accessmapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.webswing.server.common.model.security.WebswingAction;
import org.webswing.server.common.service.security.AuthenticatedWebswingUser;
import org.webswing.server.services.security.extension.accessmapping.AccessMappingExtensionConfig;
import org.webswing.server.services.security.extension.accessmapping.AccessTypeMapping;
import org.webswing.server.services.security.extension.api.SecurityModuleExtension;
import org.webswing.server.services.security.extension.api.WebswingUserDecorator;

public class AccessMappingSecurityExtension
extends SecurityModuleExtension<AccessMappingExtensionConfig> {
    private Map<WebswingAction.AccessType, AccessTypeMapping> accessMapping = new HashMap<WebswingAction.AccessType, AccessTypeMapping>();

    public AccessMappingSecurityExtension(AccessMappingExtensionConfig config) {
        super(config);
        for (AccessTypeMapping mapping : ((AccessMappingExtensionConfig)this.getConfig()).getAccessMapping()) {
            this.accessMapping.put(mapping.getAccessType(), mapping);
        }
    }

    @Override
    public AuthenticatedWebswingUser decorateUser(final AuthenticatedWebswingUser user, HttpServletRequest request, HttpServletResponse response) {
        return new WebswingUserDecorator(user){
            private static final long serialVersionUID = -3360930503393350015L;

            @Override
            public boolean isPermitted(String permission) {
                WebswingAction.AccessType[] validAccessTypes;
                try {
                    validAccessTypes = WebswingAction.valueOf(permission).getAccessTypes();
                }
                catch (IllegalArgumentException e) {
                    validAccessTypes = new WebswingAction.AccessType[]{WebswingAction.AccessType.admin};
                }
                for (WebswingAction.AccessType at : validAccessTypes) {
                    AccessTypeMapping m = (AccessTypeMapping)AccessMappingSecurityExtension.this.accessMapping.get((Object)at);
                    if (m != null) {
                        if (m.isEveryone()) {
                            return true;
                        }
                        for (String username : m.getUsers()) {
                            if (!StringUtils.equals(user.getUserId(), ((AccessMappingExtensionConfig)AccessMappingSecurityExtension.this.getConfig()).getContext().replaceVariables(username))) continue;
                            return true;
                        }
                        for (String role : m.getRoles()) {
                            if (!user.hasRole(((AccessMappingExtensionConfig)AccessMappingSecurityExtension.this.getConfig()).getContext().replaceVariables(role))) continue;
                            return true;
                        }
                        continue;
                    }
                    Set<String> defaultRoles = WebswingAction.DefaultRolePermissionResolver.getRolesForAccessType(at);
                    for (String role : defaultRoles) {
                        if (!user.hasRole(role)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

