/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security.modules;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.webswing.server.common.service.security.AuthenticatedWebswingUser;
import org.webswing.server.services.security.api.WebswingAuthenticationException;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;
import org.webswing.server.services.security.modules.AbstractExtendableSecurityModule;

public abstract class AbstractUserPasswordSecurityModule<T extends WebswingExtendableSecurityModuleConfig>
extends AbstractExtendableSecurityModule<T> {
    public AbstractUserPasswordSecurityModule(T config) {
        super(config);
    }

    @Override
    public void init() {
        super.init();
    }

    public String getPartialTemplateName() {
        return "loginPartial.html";
    }

    public String getUserName(HttpServletRequest request) {
        return request.getParameter("username");
    }

    public String getPassword(HttpServletRequest request) {
        return request.getParameter("password");
    }

    @Override
    protected AuthenticatedWebswingUser authenticate(HttpServletRequest request) throws WebswingAuthenticationException {
        String username = this.getUserName(request);
        String password = this.getPassword(request);
        if (username != null || password != null) {
            try {
                AuthenticatedWebswingUser user = this.verifyUserPassword(username, password);
                if (user != null) {
                    this.logSuccess(request, user.getUserId());
                }
                return user;
            }
            catch (WebswingAuthenticationException e) {
                this.logFailure(request, username, e.getMessage());
                throw e;
            }
        }
        return null;
    }

    @Override
    protected void serveLoginPartial(HttpServletRequest request, HttpServletResponse response, WebswingAuthenticationException exception) throws IOException {
        HashMap<String, String> variables = new HashMap<String, String>();
        if (exception != null) {
            variables.put("errorMessage", exception.getLocalizedMessage());
        }
        this.sendPartialHtml(request, response, this.getPartialTemplateName(), variables);
    }

    public abstract AuthenticatedWebswingUser verifyUserPassword(String var1, String var2) throws WebswingAuthenticationException;
}

