/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.anttasks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SplitResource
extends Task {
    private File resource = null;
    private File resourceScript = null;
    private File outputDir = null;
    private String resourceName = null;
    private String resourceType = null;
    private int chunkSize = 0;

    public static void main(String[] stringArray) {
        SplitResource splitResource = new SplitResource();
        splitResource.setResource(new File(stringArray[0]));
        splitResource.setOutputDir(new File(stringArray[1]));
        splitResource.setResourceScript(new File(stringArray[2]));
        splitResource.setResourceName(stringArray[3]);
        splitResource.setResourceType(stringArray[4]);
        splitResource.setChunkSize(Integer.parseInt(stringArray[5]));
        splitResource.execute();
    }

    public void execute() {
        DataInputStream dataInputStream;
        if (this.resource == null) {
            throw new BuildException("Error - No resource specified !!");
        }
        if (this.outputDir == null) {
            this.outputDir = new File(".");
        }
        this.outputDir.mkdir();
        if (this.chunkSize == 0) {
            throw new BuildException("Error - No chunk size specified !!");
        }
        try {
            dataInputStream = new DataInputStream(new FileInputStream(this.resource));
        }
        catch (IOException iOException) {
            throw new BuildException("Error - couldn't open the resource file");
        }
        int n = (int)(this.resource.length() / (long)this.chunkSize) + 1;
        System.out.println("Splitting file into chunks");
        System.out.println("file: " + this.resource.getAbsolutePath());
        System.out.println("file size: " + this.resource.length());
        System.out.println("chunk size: " + this.chunkSize);
        System.out.println("ergo, num chunks: " + n);
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            DataOutputStream dataOutputStream;
            File file = new File(this.outputDir, this.resource.getName() + "." + i);
            try {
                dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            }
            catch (IOException iOException) {
                throw new BuildException("Error - couldn't create a part file");
            }
            int n2 = this.chunkSize;
            if (i == n - 1) {
                n2 = (int)(this.resource.length() % (long)this.chunkSize);
            }
            byte[] byArray = new byte[n2];
            try {
                dataInputStream.readFully(byArray, 0, n2);
            }
            catch (EOFException eOFException) {
                throw new BuildException("Error - unexpectedly hit the end of the resource file");
            }
            catch (IOException iOException) {
                throw new BuildException("Error - couldn't read a byte from the resource file");
            }
            try {
                dataOutputStream.write(byArray, 0, n2);
                l += (long)n2;
            }
            catch (IOException iOException) {
                throw new BuildException("Error - couldn't write out a byte to the part file");
            }
            try {
                dataOutputStream.close();
                continue;
            }
            catch (IOException iOException) {
                throw new BuildException("Error - couldn't close a chunk output stream");
            }
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new BuildException("Error - couldn't close the input stream");
        }
        if (this.resourceScript != null && this.resourceName != null && this.resourceType != null) {
            System.out.println("Putting references into a resource script");
            System.out.println("resourceScript: " + this.resourceScript.getAbsolutePath());
            System.out.println("resourceName  : " + this.resourceName);
            System.out.println("resourceType  : " + this.resourceType);
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(this.resourceScript, true));
            }
            catch (IOException iOException) {
                throw new BuildException("Error - couldn't open the resource script");
            }
            for (int i = 0; i < n; ++i) {
                printWriter.println(this.resourceName + "_" + (i + 1) + " " + this.resourceType + " \"" + this.resource.getName() + "." + i + "\"");
            }
            printWriter.close();
        }
    }

    public void setResource(File file) {
        this.resource = file;
    }

    public void setResourceScript(File file) {
        this.resourceScript = file;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    public void setResourceType(String string) {
        this.resourceType = string;
    }

    public void setOutputDir(File file) {
        this.outputDir = file;
    }

    public void setChunkSize(int n) {
        this.chunkSize = n;
    }
}

