/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.DefaultTableModelSorter;
import de.qfs.lib.gui.FilteredAndSortedTableModel;
import de.qfs.lib.gui.SortedTableHeaderCellRenderer;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.TableModelFilter;
import de.qfs.lib.gui.TableModelFilterEvent;
import de.qfs.lib.gui.TableModelFilterListener;
import de.qfs.lib.gui.TableModelSorter;
import de.qfs.lib.gui.TableModelSorterEvent;
import de.qfs.lib.gui.TableModelSorterListener;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.DelayedAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SortedTableHelper
implements TableModelFilterListener,
TableModelSorterListener {
    private static Logger logger = new Logger(class$de$qfs$lib$gui$SortedTableHelper == null ? (class$de$qfs$lib$gui$SortedTableHelper = SortedTableHelper.class$("de.qfs.lib.gui.SortedTableHelper")) : class$de$qfs$lib$gui$SortedTableHelper);
    private static final Logger hlLogger = new Logger(class$de$qfs$lib$gui$SortedTableHelper$HeaderListener == null ? (class$de$qfs$lib$gui$SortedTableHelper$HeaderListener = SortedTableHelper.class$("de.qfs.lib.gui.SortedTableHelper$HeaderListener")) : class$de$qfs$lib$gui$SortedTableHelper$HeaderListener);
    private JTable table;
    private TableModel model;
    private FilteredAndSortedTableModel sortedModel;
    private MouseAdapter header_listener;
    private TableModelSorter sorter;
    private TableModelFilter filter;
    private TableCellRenderer renderer;
    static /* synthetic */ Class class$de$qfs$lib$gui$SortedTableHelper;
    static /* synthetic */ Class class$de$qfs$lib$gui$SortedTableHelper$HeaderListener;

    public SortedTableHelper(JTable jTable) {
        this(jTable, null, new DefaultTableModelSorter());
        this.sorter.setSortColumn(0);
        this.header_listener = new HeaderListener();
    }

    public SortedTableHelper(JTable jTable, TableModelFilter tableModelFilter, TableModelSorter tableModelSorter) {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "SortedTableHelper(JTable,TableModelSorter,TableModelFilter)", "table: " + jTable + ", " + "sorter: " + tableModelSorter + ", " + "filter: " + tableModelFilter);
        }
        this.table = jTable;
        this.model = jTable.getModel();
        this.filter = tableModelFilter;
        this.sorter = tableModelSorter;
        this.sortedModel = new FilteredAndSortedTableModel(this.model, this.filter, this.sorter);
        this.header_listener = new HeaderListener();
        this.renderer = new SortedTableHeaderCellRenderer(jTable);
    }

    public SortedTableHelper(JTable jTable, TableModelFilter tableModelFilter, TableModelSorter tableModelSorter, TableCellRenderer tableCellRenderer, MouseAdapter mouseAdapter) {
        this.filter = tableModelFilter;
        this.header_listener = mouseAdapter;
        this.model = jTable.getModel();
        this.renderer = tableCellRenderer;
        this.sorter = tableModelSorter;
        this.sortedModel = new FilteredAndSortedTableModel(this.model, this.filter, this.sorter);
        this.table = jTable;
    }

    public SortedTableHelper(JTable jTable, FilteredAndSortedTableModel filteredAndSortedTableModel) {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "SortedTableHelper(JTable,FilteredAndSortedTableModel)", "table: " + jTable + ", " + "sortedModel: " + filteredAndSortedTableModel);
        }
        this.table = jTable;
        this.sortedModel = filteredAndSortedTableModel;
        this.model = filteredAndSortedTableModel.getModel();
        this.filter = filteredAndSortedTableModel.getFilter();
        this.sorter = filteredAndSortedTableModel.getSorter();
        this.header_listener = new HeaderListener();
        this.renderer = new SortedTableHeaderCellRenderer(jTable);
    }

    public void prepareTable() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "prepareTable()", "");
        }
        this.table.setModel(this.sortedModel);
        if (this.renderer instanceof SortedTableHeaderCellRenderer) {
            ((SortedTableHeaderCellRenderer)this.renderer).reinit();
        }
        if (this.sorter != null) {
            this.sorter.addTableModelSorterListener(this);
        }
        if (this.filter != null) {
            this.filter.addTableModelFilterListener(this);
        }
        if (this.sorter != null && this.renderer instanceof TableModelSorterListener) {
            this.sorter.addTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
            ((TableModelSorterListener)((Object)this.renderer)).sortOrderChanged(new TableModelSorterEvent(this.sorter, this.sorter.getSortColumn(), this.sorter.isSortAscending()));
        }
        if (this.sorter != null || this.filter != null) {
            this.saveSelection(true);
        }
        if (this.header_listener != null) {
            this.table.getTableHeader().addMouseListener(this.header_listener);
        }
        this.header_listener = null;
    }

    public void saveSelection(boolean bl) {
        if (bl) {
            if (this.sortedModel != null && this.table != null) {
                this.sortedModel.setSavedSelectionModel(this.table.getSelectionModel());
            }
        } else if (this.sortedModel != null) {
            this.sortedModel.setSavedSelectionModel(null);
        }
    }

    public void updateUI() {
        if (this.renderer instanceof SortedTableHeaderCellRenderer) {
            this.setHeaderCellRenderer(new SortedTableHeaderCellRenderer(this.table));
        }
    }

    public final TableModel getTableModel() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "getTableModel()", "");
        }
        return this.model;
    }

    public void setTableModel(TableModel tableModel) {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "setTableModel(TableModel)", SortedTableHelper.logger.level < 8 ? "" : "model: " + tableModel);
        }
        this.model = tableModel;
        this.sortedModel.setModel(tableModel);
        if (this.renderer instanceof SortedTableHeaderCellRenderer) {
            ((SortedTableHeaderCellRenderer)this.renderer).reinit();
        }
    }

    public final FilteredAndSortedTableModel getSortedTableModel() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "getSortedTableModel()", "");
        }
        return this.sortedModel;
    }

    public void setSortedTableModel(FilteredAndSortedTableModel filteredAndSortedTableModel) {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "setSortedTableModel(FilteredAndSortedTableModel)", "model: " + filteredAndSortedTableModel);
        }
        if (this.sorter != null) {
            this.sorter.removeTableModelSorterListener(this);
            if (this.sortedModel != null) {
                this.sorter.removeTableModelSorterListener(this.sortedModel);
            }
            if (this.renderer instanceof TableModelSorterListener) {
                this.sorter.removeTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
            }
        }
        if (this.filter != null) {
            this.filter.removeTableModelFilterListener(this);
        }
        this.sortedModel = filteredAndSortedTableModel;
        this.model = this.sortedModel.getModel();
        this.sorter = this.sortedModel.getSorter();
        if (this.sorter != null) {
            this.sorter.addTableModelSorterListener(this);
        }
        this.filter = this.sortedModel.getFilter();
        if (this.filter != null) {
            this.filter.addTableModelFilterListener(this);
        }
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.table.setModel(this.sortedModel);
        if (this.renderer instanceof SortedTableHeaderCellRenderer) {
            ((SortedTableHeaderCellRenderer)this.renderer).reinit();
        }
        if (this.sorter != null && this.renderer instanceof TableModelSorterListener) {
            this.sorter.addTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
            ((TableModelSorterListener)((Object)this.renderer)).sortOrderChanged(new TableModelSorterEvent(this.sorter, this.sorter.getSortColumn(), this.sorter.isSortAscending()));
        }
    }

    public final TableModelSorter getTableModelSorter() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "getTableModelSorter()", "");
        }
        return this.sorter;
    }

    public final void setTableModelSorter(TableModelSorter tableModelSorter) {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "setTableModelSorter(TableModelSorter)", SortedTableHelper.logger.level < 8 ? "" : "sorter: " + tableModelSorter);
        }
        if (this.sorter != null) {
            tableModelSorter.removeTableModelSorterListener(this);
            if (this.renderer instanceof TableModelSorterListener) {
                this.sorter.removeTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
            }
        }
        this.sorter = tableModelSorter;
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.sortedModel.setSorter(tableModelSorter);
        if (tableModelSorter != null) {
            tableModelSorter.addTableModelSorterListener(this);
            if (this.renderer instanceof TableModelSorterListener) {
                tableModelSorter.addTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
                ((TableModelSorterListener)((Object)this.renderer)).sortOrderChanged(new TableModelSorterEvent(tableModelSorter, tableModelSorter.getSortColumn(), tableModelSorter.isSortAscending()));
            }
        }
    }

    public final TableModelFilter getTableModelFilter() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "getTableModelFilter()", "");
        }
        return this.filter;
    }

    public final void setTableModelFilter(TableModelFilter tableModelFilter) {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "setTableModelFilter(TableModelFilter)", SortedTableHelper.logger.level < 8 ? "" : "filter: " + tableModelFilter);
        }
        if (this.filter != null) {
            tableModelFilter.removeTableModelFilterListener(this);
        }
        this.filter = tableModelFilter;
        if (tableModelFilter != null) {
            tableModelFilter.addTableModelFilterListener(this);
        }
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.sortedModel.setFilter(tableModelFilter);
    }

    public final TableCellRenderer getHeaderCellRenderer() {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "getHeaderCellRenderer()", "");
        }
        return this.renderer;
    }

    public final void setHeaderCellRenderer(TableCellRenderer tableCellRenderer) {
        if (SortedTableHelper.logger.level >= 7) {
            logger.log(7, "setHeaderCellRenderer(TableCellRenderer)", SortedTableHelper.logger.level < 8 ? "" : "renderer: " + tableCellRenderer);
        }
        if (this.sorter != null && this.renderer instanceof TableModelSorterListener) {
            this.sorter.removeTableModelSorterListener((TableModelSorterListener)((Object)this.renderer));
        }
        this.renderer = tableCellRenderer;
        if (tableCellRenderer instanceof SortedTableHeaderCellRenderer) {
            ((SortedTableHeaderCellRenderer)tableCellRenderer).reinit();
        }
        if (this.sorter != null && tableCellRenderer instanceof TableModelSorterListener) {
            this.sorter.addTableModelSorterListener((TableModelSorterListener)((Object)tableCellRenderer));
            ((TableModelSorterListener)((Object)tableCellRenderer)).sortOrderChanged(new TableModelSorterEvent(this.sorter, this.sorter.getSortColumn(), this.sorter.isSortAscending()));
        }
    }

    public void filterChanged(TableModelFilterEvent tableModelFilterEvent) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    public void sortOrderChanged(TableModelSorterEvent tableModelSorterEvent) {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HeaderListener
    extends MouseAdapter {
        private DelayedAction delay = new DelayedAction(300);

        private HeaderListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (hlLogger.level >= 7) {
                hlLogger.log(7, "mouseClicked(MouseEvent)", hlLogger.level < 8 ? "" : "e: " + mouseEvent);
            }
            int n = SortedTableHelper.this.table.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            final int n2 = SortedTableHelper.this.table.convertColumnIndexToModel(n);
            if (n != -1) {
                if (mouseEvent.getClickCount() == 1) {
                    if (SortedTableHelper.this.sorter != null) {
                        this.delay.perform(new Runnable(){

                            public void run() {
                                SortedTableHelper.this.sorter.setSortColumn(n2);
                            }
                        });
                    }
                } else {
                    this.delay.cancel();
                    if (mouseEvent.getClickCount() == 2) {
                        SwingUtil.autoSizeTableColumn(SortedTableHelper.this.table, n);
                    }
                }
            }
        }
    }
}

