/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LogEntry;

public class LogQueue {
    private boolean queueing = true;
    private LogEntry cubby;
    private int maxSize = 3000;
    private boolean drop = false;
    private LogEntry[] array = new LogEntry[this.maxSize];
    private int head;
    private int tail;
    private int size = 0;

    LogQueue() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void push(LogEntry logEntry) {
        while (true) {
            block11: {
                if (this.queueing) {
                    if (this.size == this.maxSize) {
                        if (this.drop) {
                            if (++this.tail == this.maxSize) {
                                this.tail = 0;
                            }
                            this.array[this.head++] = logEntry;
                            if (this.head == this.maxSize) {
                                this.head = 0;
                            }
                            this.notifyAll();
                            return;
                        }
                        break block11;
                    } else {
                        this.array[this.head++] = logEntry;
                        if (this.head == this.maxSize) {
                            this.head = 0;
                        }
                        ++this.size;
                        this.notifyAll();
                        return;
                    }
                }
                if (this.cubby == null) {
                    this.cubby = logEntry;
                    this.notifyAll();
                    return;
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized LogEntry pop() {
        while (!this.queueing ? this.cubby == null : this.size == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.queueing) {
            LogEntry logEntry = this.array[this.tail];
            this.array[this.tail++] = null;
            if (this.tail == this.maxSize) {
                this.tail = 0;
            }
            --this.size;
            return logEntry;
        }
        LogEntry logEntry = this.cubby;
        this.cubby = null;
        return logEntry;
    }

    public synchronized LogEntry[] popAll() {
        LogEntry[] logEntryArray;
        while (!this.queueing ? this.cubby == null : this.size == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.queueing) {
            logEntryArray = new LogEntry[this.size];
            if (this.head > this.tail) {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.size);
            } else {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.maxSize - this.tail);
                if (this.head > 0) {
                    System.arraycopy(this.array, 0, logEntryArray, this.maxSize - this.tail, this.head);
                }
            }
            this.array = new LogEntry[this.maxSize];
            this.size = 0;
            this.tail = 0;
            this.head = 0;
        } else {
            logEntryArray = new LogEntry[]{this.cubby};
            this.cubby = null;
        }
        return logEntryArray;
    }

    public synchronized void entriesProcessed() {
        this.notifyAll();
    }

    public final boolean isQueueing() {
        return this.queueing;
    }

    public final synchronized void setQueueing(boolean bl) {
        if (this.queueing != bl) {
            while (!this.queueing ? this.cubby != null : this.size != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.queueing = bl;
            this.notifyAll();
        }
    }

    public final int getQueueSize() {
        return this.maxSize;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void setQueueSize(int var1_1) {
        if (var1_1 != this.maxSize) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            if (this.drop) {
                this.tail += this.size - var1_1;
                if (this.tail > this.maxSize) {
                    this.tail -= this.maxSize;
                }
                this.size = var1_1;
                continue;
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException var2_2) {
                // empty catch block
            }
lbl14:
            // 4 sources

            ** while (this.queueing && this.size > var1_1)
        }
lbl15:
        // 1 sources

        var2_3 = new LogEntry[var1_1];
        if (this.queueing && this.size > 0) {
            if (this.head > this.tail) {
                System.arraycopy(this.array, this.tail, var2_3, 0, this.size);
            } else {
                System.arraycopy(this.array, this.tail, var2_3, 0, this.maxSize - this.tail);
                if (this.head > 0) {
                    System.arraycopy(this.array, this.tail, var2_3, this.maxSize - this.tail, this.head);
                }
            }
        }
        this.maxSize = var1_1;
        this.array = var2_3;
        this.head = this.size;
        this.tail = 0;
        this.notifyAll();
    }

    public final boolean isDropOnOverflow() {
        return this.drop;
    }

    public synchronized void setDropOnOverflow(boolean bl) {
        this.drop = bl;
        this.notifyAll();
    }
}

