@echo off
pushd "%CD%"
CD /D "%~dp0"

set extdesc=the Solr9 Extension
if "%GSDL3SRCHOME%" == "" echo Run the toplevel gs3-setup.bat before calling this script& goto End


set GEXT_SOLR9=%CD%
set SOLR_HOME=%GSDL3DATAHOME%\ext\solr9

setlocal enabledelayedexpansion
set FOUNDPROPS=
set SOLR_PORT=7983
set SOLR_HOST=127.0.0.1

FOR /F "usebackq tokens=1,2 delims==" %%G IN ("%GEXT_SOLR9%\build.properties") DO ( 
	if "%%G"=="localhost.http" set SOLR_HOST=%%H& set FOUNDPROPS=!FOUNDPROPS!found
	if "%%G"=="solr.port" set SOLR_PORT=%%H& set FOUNDPROPS=!FOUNDPROPS!found
	:: break out of the loop as soon as both properties are found
	if "!FOUNDPROPS!" == "foundfound" goto foundall
)

:foundall
endlocal& set SOLR_HOST=%SOLR_HOST%& set SOLR_PORT=%SOLR_PORT%


if "%OS%" == "Windows_NT" goto WinNT
if "%OS%" == "" goto Win95
echo Setup failed - your PATH has not been set

goto End

:WinNT
::set GEXT_SOLR=%CD%
set PATH=%GEXT_SOLR%\bin\script;%PATH%
set PATH=%GEXT_SOLR%\lib;%PATH%
set GS_CP_SET=yes
goto Success

:Win95
if "%1" == "SetEnv" goto Win95Env
REM We'll invoke a second copy of the command processor to make
REM sure there's enough environment space
COMMAND /E:2048 /K %0 SetEnv
goto End

:Win95Env
::set GEXT_SOLR=%CD%
set PATH="%GEXT_SOLR%\bin\script";"%PATH%"
set PATH="%GEXT_SOLR%\lib";"%PATH%"
set GS_CP_SET=yes
goto Success

:Success

set fulldir=%~dp0

:: strip off everything up to (and including) ext dir
set extdir=%fulldir:*ext\=%

:: remove trailing slash
set extdir=%extdir:\=%

setlocal enabledelayedexpansion
if "x%GSDL3EXTS%" == "x" (
  set GSDL3EXTS=!extdir!
) else (
  set GSDL3EXTS=!GSDL3EXTS!:!extdir!
)
endlocal & set GSDL3EXTS=%GSDL3EXTS%

:: Back to delayed expansion to avoid problems with environment
:: variables with brackets in them, such as "Program Files (x86)"

echo +Your environment is now setup for %extdesc%
echo   - Solr API accessed internally via: http://%SOLR_HOST%:%SOLR_PORT%
:End

popd
