/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: Shaoqun Wu, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gems;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import java.util.HashMap;


import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.GLIButton;

public class DeleteMetadataSetPrompt 
    extends ModalDialog { 

    static private Dimension SIZE = new Dimension(500, 500);
        
    private ArrayList available_metadata_sets;
    private ArrayList listeners;

    private JCheckBox confirmation = null;
    private JButton delete_button = null;
    private JButton close_button = null;    
    private JList available_set_list = null;
    /** The model behind the list. */
    private DefaultListModel list_model = null;
    private JTextArea description_textarea = null;
    private DeleteMetadataSetPrompt self;
    private MetadataSetManager meta_manager;
  
    public DeleteMetadataSetPrompt(Frame parent,MetadataSetManager msm) {
	super(parent, true);
        self = this;
	meta_manager = msm;
        listeners = new ArrayList();      

	setSize(SIZE);
	setTitle(Dictionary.get("GEMS.DeleteMetadataSetPrompt.Title"));
   
	JPanel content_pane = (JPanel) getContentPane();
        content_pane.setOpaque(true);
	content_pane.setComponentOrientation(Dictionary.getOrientation());

	JLabel available_metadata_sets_label = new JLabel(Dictionary.get("GEMS.DeleteMetadataSetPrompt.Available_Sets"));
	available_metadata_sets_label.setOpaque(true);
        available_metadata_sets_label.setComponentOrientation(Dictionary.getOrientation());
	
	list_model = new DefaultListModel();
	
        available_set_list = new JList();
	available_set_list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	available_set_list.setModel(list_model);
	available_set_list.setCellRenderer(new MetadatSetListCellRenderer()); 
	available_set_list.setFixedCellHeight(20);
	available_set_list.addListSelectionListener(new MetadataSetListSelectionListener());
        available_set_list.setComponentOrientation(Dictionary.getOrientation());
        
	JPanel set_pane = new JPanel();
        set_pane.setComponentOrientation(Dictionary.getOrientation());
        set_pane.setLayout(new BorderLayout());
        set_pane.add(available_metadata_sets_label,BorderLayout.NORTH);
	set_pane.add(new JScrollPane(available_set_list),BorderLayout.CENTER);


	JLabel metadata_set_des_label = new JLabel(Dictionary.get("GEMS.Set_Description"));
	metadata_set_des_label.setOpaque(true);

	description_textarea = new JTextArea();
        description_textarea.setOpaque(true);
        description_textarea.setEditable(false);
        description_textarea.setLineWrap(true); 
        description_textarea.setWrapStyleWord(true);
	description_textarea.setComponentOrientation(Dictionary.getOrientation());
        
	JPanel des_pane = new JPanel();
        des_pane.setComponentOrientation(Dictionary.getOrientation());
        des_pane.setLayout(new BorderLayout());
        des_pane.add(metadata_set_des_label,BorderLayout.NORTH);
	des_pane.add(new JScrollPane(description_textarea),BorderLayout.CENTER);
	
	JPanel button_pane = new JPanel();
        button_pane.setComponentOrientation(Dictionary.getOrientation());
	delete_button = new GLIButton(Dictionary.get("GEMS.DeleteMetadataSetPrompt.Delete"), Dictionary.get("GEMS.DeleteMetadataSetPrompt.Delete_Tooltip"));
	delete_button.setEnabled(false);
	

	confirmation = new JCheckBox(Dictionary.get("GEMS.DeleteMetadataSetPrompt.Confirm_Delete"));
	confirmation.setEnabled(false);
	confirmation.setSelected(false);
        confirmation.setComponentOrientation(Dictionary.getOrientation());
        
	close_button = new GLIButton(Dictionary.get("General.Close"), Dictionary.get("General.Close_Tooltip"));
	close_button.setEnabled(true);

	confirmation.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent event) {
		    delete_button.setEnabled(confirmation.isSelected());
		    //confirmation.setEnabled(false);
		    //confirmation.setSelected(false);
		}
	    });

	// Add listeners
	delete_button.addActionListener(new DeleteButtonListener());
	
	close_button.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent event) {
		    self.dispose();
		}
	    });

       
	button_pane.setLayout(new GridLayout(1,2));
	button_pane.add(delete_button);
	button_pane.add(close_button);

        JPanel bottom_pane = new JPanel();
        bottom_pane.setComponentOrientation(Dictionary.getOrientation());
        bottom_pane.setLayout(new BorderLayout());
	bottom_pane.add(confirmation,BorderLayout.NORTH);
	bottom_pane.add(button_pane, BorderLayout.CENTER);


	content_pane.setLayout(new BorderLayout());
	content_pane.add(set_pane, BorderLayout.NORTH);
	content_pane.add(des_pane, BorderLayout.CENTER);
	content_pane.add(bottom_pane, BorderLayout.SOUTH);
	
	// Show
	Dimension screen_size = Configuration.screen_size;
	setLocation((screen_size.width - SIZE.width) / 2, (screen_size.height - SIZE.height) / 2);
	setVisible(false);
    }

      
    public void display() {
	available_metadata_sets = meta_manager.getAvailableMetadataSets();
	for (int i=0; i<available_metadata_sets.size(); i++) {
	    list_model.addElement(available_metadata_sets.get(i));
	}
	//available_set_list.setListData(new Vector((Collection)available_metadata_sets));
	delete_button.setEnabled(false);
	confirmation.setEnabled(false);
	confirmation.setSelected(false);
       	setVisible(true); 
        
    }


    /** The Delete button listener implementation. */
    private class DeleteButtonListener 
	implements ActionListener {
	/** Any implementation of ActionListener must include this method so we can be informed when the button is actioned.
	 * @param event An <strong>ActionEvent</strong> containing all the relevant information garnered from the event itself.
	 * @see org.greenstone.gatherer.Configuration
	 * @see org.greenstone.gatherer.Gatherer
	 * @see org.greenstone.gatherer.util.Utility
	 */
	public void actionPerformed(ActionEvent event) {
	    // Delete the selected MetadataSet.
	    Object selectedValue = available_set_list.getSelectedValue();
		
	    if (selectedValue !=null && (selectedValue instanceof MetadataSetInfo)){
		((MetadataSetInfo)selectedValue).deleteMetadataSet();
		list_model.removeElement(selectedValue);
	    }
	    delete_button.setEnabled(false);
	    confirmation.setEnabled(false);
	    confirmation.setSelected(false);
	    description_textarea.setText(Dictionary.get("GEMS.DeleteMetadataSetPrompt.No_Set"));
	    //self.dispose();
	}

    }


    private class MetadatSetListCellRenderer extends JLabel implements ListCellRenderer {
	public MetadatSetListCellRenderer() {
	    setOpaque(true);
            this.setComponentOrientation(Dictionary.getOrientation());
	}
	
	public Component getListCellRendererComponent(JList list,
						      Object value,
						      int index,
						      boolean isSelected,
						      boolean cellHasFocus)
	{
	    String name= "unknown";

	    if (value instanceof MetadataSetInfo){
		MetadataSetInfo meta_info = (MetadataSetInfo) value;
		name = meta_info.getMetadataSetName(); 
	    }
  
            setText(name);
            if (isSelected) {
		setBackground(list.getSelectionBackground());
		setForeground(list.getSelectionForeground());
	    }
	    else {
		setBackground(list.getBackground());
		setForeground(list.getForeground());
	    }
	              
	    return this;
	}
    }

   
    private class MetadataSetListSelectionListener implements ListSelectionListener  {
        public void valueChanged(ListSelectionEvent lse){
	    if (lse.getValueIsAdjusting()) return;
	    
	    delete_button.setEnabled(false);
	   
	    Object selectedValue = available_set_list.getSelectedValue();

            if (selectedValue !=null && (selectedValue instanceof MetadataSetInfo)){
                MetadataSetInfo meta_info = (MetadataSetInfo)selectedValue; 
		description_textarea.setText(meta_info.getMetadataSetDescription());
		confirmation.setEnabled(true);
		confirmation.setSelected(false);
	    }
	    else {
		confirmation.setEnabled(false);
		description_textarea.setText(Dictionary.get("GEMS.DeleteMetadataSetPrompt.No_Set"));
	    }      

	}
    }
    

    
    public void addMetadataSetListener(MetadataSetListener msl){
        listeners.add(msl);  
    }


}
