/**
 *#########################################################################
 *
 * A component of the Greenstone Librarian Interface (GLI) application, 
 * part of the Greenstone digital library software suite from the New 
 * Zealand Digital Library Project at the University of Waikato, 
 * New Zealand.
 *
 * Author: John Thompson
 *         Greenstone Project, New Zealand Digital Library
 *         University of Waikato
 *         http://www.nzdl.org
 *
 * Copyright (C) 2004 New Zealand Digital Library, University of Waikato
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.Utility;

/** Generates a pretty about dialog which not only thanks those for their contributions but also meets our legal requirements if we wish to ship the JVM with GLI.
 * @author John Thompson, Greenstone Project, New Zealand Digital Library, University of Waikato
 * @version 2.41 final
 */
// RICOH SOURCE CODE PUBLIC LICENSE - http://www.risource.org/RPL/RPL-1.0A.shtml
public class AboutDialog
    extends JDialog {
    /** The default size of the about dialog. */
    static final private Dimension SIZE = new Dimension(600, 325);
    /** The size of the GLI icon to display on dialog. */
    static final private int ICON_SIZE = 65;
    /** A reference to ourself so that our inner classes can dismiss us. */
    private AboutDialog self;
    /** The button used for dismissing the about dialog. */
    private JButton close_button;
    /** The constructor not only builds, but displays the about dialog. This method doesn't return until the dialog is dismissed.
     * @param parent the JFrame which owns this dialog for use in centering the dialog
     * @see org.greenstone.gatherer.Dictionary#get
     * @see org.greenstone.gatherer.Dictionary#setBoth
     * @see org.greenstone.gatherer.Dictionary#setText
     * @see org.greenstone.gatherer.gui.AboutDialog.CloseButtonListener
     * @see org.greenstone.gatherer.gui.GLIButton
     */
    public AboutDialog(JFrame parent) {
	super(parent, Dictionary.get("AboutDialog.Title"), true);
	this.self = this;
	setSize(SIZE);
        this.setComponentOrientation(Dictionary.getOrientation());        
	JPanel content_pane = (JPanel) getContentPane();
        content_pane.setComponentOrientation(Dictionary.getOrientation());
        
	JPanel upper_pane = new JPanel();
        upper_pane.setComponentOrientation(Dictionary.getOrientation());
        
	String gmedium_image = "gatherer_medium.png";
	if (Configuration.fedora_info.isActive()) {
	    gmedium_image = "fli-" + gmedium_image;
	}

	ImageIcon icon = JarTools.getImage(gmedium_image);
	ImageIcon scaled_icon = new ImageIcon(icon.getImage().getScaledInstance(ICON_SIZE, ICON_SIZE, Image.SCALE_DEFAULT));
	JLabel icon_label = new JLabel(scaled_icon);
	icon_label.setComponentOrientation(Dictionary.getOrientation());
        
        JPanel title_pane = new JPanel();
	title_pane.setComponentOrientation(Dictionary.getOrientation());
        
        JLabel title_one_label = new JLabel(Dictionary.get("AboutDialog.Title_One"));
	title_one_label.setComponentOrientation(Dictionary.getOrientation());
        JLabel title_two_label = new JLabel(Gatherer.PROGRAM_NAME + " " + Gatherer.PROGRAM_VERSION + " " + Dictionary.get("AboutDialog.Date"));
        title_two_label.setComponentOrientation(Dictionary.getOrientation());
        JLabel title_three_label = new JLabel(Dictionary.get("AboutDialog.Title_Two"));
	title_three_label.setComponentOrientation(Dictionary.getOrientation());
        JLabel copyright_label = new JLabel(Dictionary.get("AboutDialog.Copyright"));
	copyright_label.setComponentOrientation(Dictionary.getOrientation());
        JLabel gpl_label = new JLabel(Dictionary.get("AboutDialog.Copyright_Two"));
        gpl_label.setComponentOrientation(Dictionary.getOrientation());
        
	JTextArea text = new JTextArea();
        text.setComponentOrientation(Dictionary.getOrientation());
	text.setLineWrap(true);
	text.setWrapStyleWord(true);
        
        
	JPanel button_pane = new JPanel();
        button_pane.setComponentOrientation(Dictionary.getOrientation());
	close_button = new GLIButton(Dictionary.get("General.Close"), Dictionary.get("General.Close_Tooltip"));
	
	// Connection
	close_button.addActionListener(new CloseButtonListener());

	// Layout
	icon_label.setBorder(BorderFactory.createEmptyBorder(0,0,0,10));

	title_pane.setLayout(new GridLayout(5,1,0,2));
	title_pane.add(title_one_label);
	title_pane.add(title_two_label);
	title_pane.add(title_three_label);
	title_pane.add(copyright_label);
	title_pane.add(gpl_label);
		  
	upper_pane.setBorder(BorderFactory.createEmptyBorder(0,0,5,0));
	upper_pane.setLayout(new BorderLayout());
	upper_pane.add(icon_label, BorderLayout.LINE_START);
	upper_pane.add(title_pane, BorderLayout.CENTER);

	button_pane.setBorder(BorderFactory.createEmptyBorder(5,0,0,0));
	button_pane.setLayout(new BorderLayout());
	button_pane.add(close_button, BorderLayout.LINE_END);

	content_pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	content_pane.setLayout(new BorderLayout());
	content_pane.add(upper_pane, BorderLayout.NORTH);
	content_pane.add(new JScrollPane(text), BorderLayout.CENTER);
	content_pane.add(button_pane, BorderLayout.SOUTH);

	// Build text content
	text.append(Dictionary.get("AboutDialog.Java_Req"));
	text.append("\n");
	text.append(Dictionary.get("AboutDialog.Java_Req_One"));
	text.append("\n");
	text.append(Dictionary.get("AboutDialog.Java_Req_Two"));
	text.append("\n\n");
	text.append("*****" + Dictionary.get("AboutDialog.Acknowledgement") + "*****");
	text.append("\n\n");
	text.append(Dictionary.get("AboutDialog.Item0"));
	text.append("\n\n");
	text.append(Dictionary.get("AboutDialog.Item2"));
	text.append("\n\n");
	text.append(Dictionary.get("AboutDialog.Item3"));
	text.append("\n\n");
	text.append("*****" + Dictionary.get("AboutDialog.Thanks") + "*****");
	text.append("\n\n");
	text.append(Dictionary.get("AboutDialog.Item4"));
	text.append("\n\n");
	text.append(Dictionary.get("AboutDialog.Item5"));
	text.append("\n\n");
	text.append(Dictionary.get("AboutDialog.Item6"));
	text.append("\n\n");
	text.append(Dictionary.get("AboutDialog.Item7"));
	text.append("\n\n");
	text.append(Dictionary.get("AboutDialog.Item8"));
	text.append("\n\n");
	text.append(Dictionary.get("AboutDialog.Item9"));
	text.append("\n\n");
	text.setCaretPosition(0);

	// Show
	Rectangle frame_bounds = parent.getBounds();
	setLocation(frame_bounds.x + (frame_bounds.width - SIZE.width) / 2, frame_bounds.y + (frame_bounds.height - SIZE.height) / 2);
	setVisible(true);
    }
    /** Listens for actions upon the close button, and when detected closes the dialog. */
    private class CloseButtonListener
	implements ActionListener {
	/** Called whenever an action occurs on the close button, thus asking the dialog to close.
	 * @param event an ActionEvent containing information about the button press
	 */
	public void actionPerformed(ActionEvent event) {
	    self.setVisible(false);
	    self.dispose();
	}
    }
}
