/*
 *    MGPPSearchWrapper.java
 *    Copyright (C) 2002 New Zealand Digital Library, http://www.nzdl.org
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.greenstone.mgpp;

import java.util.Vector;

/** java wrapper class for access to mgpp in C++
 *
 * the native side implemented in MGPPWrapperImpl.cpp
 * uses MGPPQueryResult to hold the result of a query. the 
 * result of a getDocument is a String
 * uses the jni
 *
 *@see MGPPQueryResult
 */
public class MGPPSearchWrapper {
  
    /** the query result
     * will be filled in by runQuery
     */
    protected MGPPQueryResult mgpp_query_result_=null; 
    /** pointer to c++ MGPPWrapperData class - cached indexData and queryInfo
     */
    protected long mgpp_data_ptr_=0;

    static {
	String gsdlos = System.getenv("GSDLOS");
	if (gsdlos!=null && gsdlos.equals("darwin")) {
	    // As of MacOX 10.11 (El Capitan), effectivly supresses DYLD_LIBRARY_PATH (does
	    // not propagate it to child processes).  This is a result of changes to their
	    // security model, and seems to come into effect for 'untrusted' executables.
	    // Greenstone run as a regular user, is 'unstrusted'.  It is possible, with
	    // admin rights, to override this, however that is not really a viable solution
	    // for our project.  Hence the change here to use Systen.load() with an
	    // absolute pathname, rather than rely of System.loadLibrary().

	    String gsdl3srchome = System.getenv("GSDL3SRCHOME");
	    String full_jni_library = gsdl3srchome + "/lib/jni/libmgppsearchjni.jnilib";
	    System.load(full_jni_library);
	}
	else {
	    System.loadLibrary("mgppsearchjni");
	}

	initIDs();
    }
    
    public MGPPSearchWrapper() {
	mgpp_query_result_ = new MGPPQueryResult();
	initCppSide();
    }

    /** initialises field and method IDs for java side to enable access on
	C++ side */
    private static native void initIDs();

    /** initialises the mgpp_data_ptr_ */
    private native boolean initCppSide();

    /** returns a document: number docnum at level level 
     * text_path path should provide
     * the absolute location of the mgpp text files eg ..../index/text/demo
     * returns the doc in utf-8
     */
    //only this method is for search purpose
//    public native String getDocument(String text_path,
//				     String level,
//				     long docnum );

    /** the public method - converts between utf-8 and unicode
     */
    // public String getDocument(String text_path,
    //		      String level,
    //		      long docnum ) {

    //String utf8_doc = getUtF8Document(base_dir, text_path, level, docnum);
	
    /** load up the data structure for index 
     * - maintains state between requests as can be slow  
     * index_path should provide
     * the absolute location of the mgpp index files eg ..../index/tt/demo 
     */
    public native boolean loadIndexData(String index_path);
    /** unloads the data */
    public native boolean unloadIndexData();

  /** reset all the params back to their defaults */
  public native void reset();
    // query param methods

    /** if on=true, sets default stemming on  - its off by default*/
    public native void setStem(boolean on);
    
    /** if on=true, sets default accentfolding on  - its off by default*/
    public native void setAccentFold(boolean on);

   /** if on=true, sets default casefolding on - its off by default */
   public native void setCase(boolean on);
    /** default is 50 */
    public native void setMaxDocs(int num);
    /** if on=true, sorts by rank, otherwise returns in build order - 
	default is on */
    public native void setSortByRank(boolean on);
    /** if on=true, a query returns term freq info - default is on */
    public native void setReturnTerms(boolean on);
    /** sets the granularity of the  query  - default 'Document' */
    public native void setQueryLevel(String level);
    /** sets the granularity of the result - default 'Document' */
    public native void setReturnLevel(String level);
    /** sets the default boolean operator - AND(=1)/OR(=0) */
    public native void setMatchMode(int mode);

    /** sets maxnumeric */
    public native void setMaxNumeric(int maxnumeric);
    /** returns a string with all the current query param settings */
    public native String getQueryParams();

    /** actually carry out the query. Use the set methods to set any query
	params 
    * writes the result to query_result
    */
    public native void runQuery(String query_string); 

    /** get the result out of the wrapper */
    public MGPPQueryResult getQueryResult() {
	return mgpp_query_result_;
    }
    
}
