#!/bin/bash

#export crossOS=windows
export crossOS=android

if [ $crossOS = "windows" ] ; then
  export crossHost=i686-w64-mingw32
elif [ $crossOS = "android" ] ; then
  export crossHost=arm-linux-androideabi
fi

export CROSSCONFIGURE_VARS="CPP=$crossHost-cpp CC=$crossHost-gcc CXX=$crossHost-g++ LD=$crossHost-ld AR=$crossHost-ar RANLIB=$crossHost-ranlib"

export CROSSCONFIGURE_ARGS="--host=$crossHost"

if [ $crossOS = "android" ] ; then

  if [ "x$1" = "xtarclean" ] ; then
    /bin/rm .CONFIG-UPDATE-DONE
  elif [ ! -f .CONFIG-UPDATE-DONE ] ; then
    ./ANDROID-FIX-CONFIG.sh

    echo "Updated config.guess and config.sub files" > .CONFIG-UPDATE-DONE

    echo "Applying android.patchs"
    cd packages \
       && patch -p0 < android-patches/gettext-android.patch \
       && patch -p0 < android-patches/libxml2-android.patch \
       && patch -p0 < android-patches/dbus-android.patch \
       && patch -p0 < android-patches/glib-android.patch \
       && cd ..
    sleep 3

  fi
fi

./CASCADE-MAKE.sh $*



