###########################################################################
#
# extrametautil.pm -- various useful utilities
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

package extrametautil;

use strict;

use util;
#use Encode;
#use File::Copy;
use File::Basename;


# extrametakeys - an array that contains all the filenames for which we have
# some added metadata
#---------------------------------
sub addmetakey {
	my ($extrametakeys, $filename_re_for_metadata) = @_;
	push(@$extrametakeys, $filename_re_for_metadata);
}

# extrametafiles - a hash on filenames (the files to which metadata will be 
# associated), containing a hash of file->fullfilename for all the metadata 
# files that metadata was obtained from
#-------------------------------------------

sub addmetafile {
    my ($extrametafile, $filename_re_for_metadata, $file, $filename_full_path) = @_;
    if (!defined $extrametafile->{$filename_re_for_metadata}) {
	$extrametafile->{$filename_re_for_metadata} = {};
    }
    $extrametafile->{$filename_re_for_metadata}->{$file} = $filename_full_path;
}

# was called setmetafile
sub setmetafilehash {
	my ($extrametafile, $filename_re_for_metadata, $file_hash) = @_;
	$extrametafile->{$filename_re_for_metadata} = $file_hash;
}
 
# was called getmetafile
sub getmetafilehash {
	my ($extrametafile, $filename_re_for_metadata) = @_;
	return $extrametafile->{$filename_re_for_metadata};
}

# extrametadata - a hash on filenames (the files to which metadata will be 
# associated), containing a hash of name->[value array] pairs of metadata
#----------------------------------------

# set the metadata hash for a particular file
sub setmetadata {
	my ($extrametadata, $filename_re_for_metadata, $meta_hash) = @_;
	$extrametadata->{$filename_re_for_metadata} = $meta_hash;
}

# gets the metadata hash for a particular file
sub getmetadata {
	my ($extrametadata, $filename_re_for_metadata) = @_;
	return $extrametadata->{$filename_re_for_metadata};
}

# add a single value to a specific metadata field
sub addmetadatum {
    my ($extrametadata, $filename_re_for_metadata, $field_name, $value) = @_;
    if (!defined  $extrametadata->{$filename_re_for_metadata}->{$field_name}) {
	$extrametadata->{$filename_re_for_metadata}->{$field_name} = [];
    }
    my $metaname_vals = $extrametadata->{$filename_re_for_metadata}->{$field_name};
    push(@$metaname_vals, $value); 
}

# get a specific value for a particular metadata field
# e.g. $extrametadata->{$filename_re_for_metadata}->{"dc.Identifier"}->[0]
sub getmetadatum_by_index {
    my ($extrametadata, $filename_re_for_metadata, $metaname, $index) = @_;
    return $extrametadata->{$filename_re_for_metadata}->{$metaname}->[$index]; 
}



1;
