#!/bin/bash

function check_exists {
    local prog_name=$1
    local ext_name=$2

    local status=0

    echo ""
    echo "Checking for '$prog_name'"

    if type -p $prog_name > /dev/null ; then
	echo "  => Found $prog_name executable in PATH"
    else
	echo "****" 1>&2
	echo "* Failed to find '$prog_name'" 1>&2
	echo "*" 1>&2    
	echo "* => Consider cd'ing to ext-cli, running get-${ext_name}.sh" 1>&2
	echo "*    and then source ./SETUP-CLI.sh (from the ext-cli folder)" 1>&2
	echo "****" 1>&2
	echo "" 1>&2    
#	echo "Exiting check sequence ..." 1>&2
#	echo "" 1>&2
	status=1
    fi

    return $status
}

check_exists java  "selfcontained-jdk"
found_java=1

check_exists ant   "selfcontained-ant"
found_ant=1

check_exists javac "selfcontained-jdk"
found_javac=1

check_exists perl "selfcontained-perl-with-cpan"
found_perl=1

if [ $? != 0 ] ; then
    if [ $found_java = 1 ] ; then
	echo "Having found 'java' but not 'javac' means you can run Greenstone3, but not compile it"
    fi
else
    # found javac
    if [ "x$JAVA_HOME" == "x" ] ; then
	echo ""
	echo "Warning: JAVA_HOME not set, which means you will be unable to compile in JNI support"
    fi

    echo ""
    echo "----"
    echo "A typical compile sequence is:"
    echo "    ant"
    echo "    # review and edit (if required) build.properies"
    echo "    ant prepare"
    echo "    ant install"
    echo "----"
fi

echo ""

echo "----"
echo "To start a Greenstone3 installation, enter:"
echo "    ant start"
echo "----"
