#!/bin/bash

if [ $# != 1 ] ; then
    echo "" >&2
    echo "Usage: $0 installation-name" >&2
    echo "" >&2       
    exit 1
fi


install_name=$1

svn_message="Creating initial directory structure for installation '$install_name'"

echo ""
echo "To create an initial directory structure, select and run from the following:"
echo "----"
echo "     # Top-level folder for '$install_name'"
echo "    " svn mkdir --parents -m \""$svn_message"\" https://svn.greenstone.org/gs3-installations/$install_name/trunk

echo ""
echo "     # Site files for '$install_name'"
echo "    " svn mkdir --parents -m \""$svn_message"\" https://svn.greenstone.org/gs3-installations/$install_name/trunk/sites/$install_name

echo ""
echo "     # Interface files for '$install_name'"
echo "    " svn mkdir --parents -m \""$svn_message"\" https://svn.greenstone.org/gs3-installations/$install_name/trunk/interfaces/$install_name
echo "----"

echo ""
