<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xslt="output.xsl"
	xmlns:java="http://xml.apache.org/xslt/java"
	xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"
	xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
	extension-element-prefixes="java">
	<xsl:param name="interface_name"/>
	<xsl:param name="library_name"/>
	<xsl:param name="site_name"/>
	<xsl:param name="use_client_side_xslt"/>
	<xsl:param name="collName"/>
	<xsl:param name="lang"/>
  
	<xsl:output method="xml"/>
	<xsl:namespace-alias stylesheet-prefix="xslt" result-prefix="xsl"/>

	<!-- With gsf:interfaceText, a user can request a string from the interface dictionaries in the current lang. Use attribute propertyFile to change which dictionary file to look in. -->
	<xsl:template match="gsf:interfaceText" name="gsf:interfaceText">
	  <xsl:choose>
	    <xsl:when test="@propertyFile">
	      <xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, @propertyFile, $lang, @name, '')"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, $lang, @name)"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:template>

	<!-- With gsf:collectionText, a user can request a string from the collection's dictionary in the current lang -->
	<xsl:template match="gsf:collectionText" name="gsf:collectionText">
	  <xsl:choose>
            <xsl:when test="@propertyFile">
	      <xsl:copy-of select="util:getCollectionText($collName, $site_name, @propertyFile, $lang, @name, @args)/node()"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:copy-of select="util:getCollectionText($collName, $site_name, $lang, @name, @args)/node()"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:template>


	<xsl:template match="*">
		<xsl:copy>
		<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>


