<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:java="http://xml.apache.org/xslt/java"
	xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
	xmlns:gslib="http://www.greenstone.org/skinning"
	xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"
	extension-element-prefixes="java util"
	exclude-result-prefixes="java util gsf">
  
	<xsl:template name="webswing-embed-collage">
	  <link rel="stylesheet" href="/{$webswing_context}/css/style.css" />
	  <div id="webswing-collage" class="webswing-element" data-webswing-instance="webswingInstance0" style="width: 800px; height: 400px;">
	    
	    <div id="loading" class="ws-modal-container">
              <div class="ws-login">
		<div  class="ws-login-content">
                  <div class="ws-spinner">
		    <div class="ws-spinner-dot-1"><xsl:comment>filler</xsl:comment></div>
		    <div class="ws-spinner-dot-2"><xsl:comment>filler</xsl:comment></div>
		  </div>
		</div>
              </div>
	    </div>
	    
	  </div>

	  <gsf:script>
	    // https://www.webswing.org/docs/23.2/configure/applet.html
	    // https://www.webswing.org/docs/23.2/configure/swing.html
	    // https://www.webswing.org/docs/23.2/integrate/javascript-api?_h=customArgs%2Cargs#usage-with-customization-and-options	    
	    // https://www.webswing.org/docs/23.2/integrate/embed.html
	    // https://www.webswing.org/docs/20.1/integrate/urlparams.html
	    // https://www.webswing.org/docs/23.2/integrate/urlparams.html
	    // https://www.webswing.org/docs/20.1/integrate/customize.html
	    // https://www.webswing.org/docs/2.7/integrate/embed.html
	    
    var webswingInstance0 = {
        options: {
        autoStart: true,	
	//appletParams: {"collection":"smallbea", "library":"library"},
            connectionUrl:'/' + gs.xsltParams.webswing_context + '/collage',

	    customization: function(injector) {
	    injector.services.base.handleActionEvent = function(actionName, data, binaryData) {
       	        //console.log("WebSwing actionEvent callback handler: called with actionName = " + actionName);

	        if (actionName === "openURL") {
	          var url = data;
		  // check if a target tab/window name has been specified
		  // TODO: Any better way of passing > 1 string between Java and JavaScript?
		  var index = url.indexOf(" - ");
		  if (index !== -1) {
		     var target = url.substring(index+3); // skip past " - " to get target name
		     url = url.substring(0, index);
		     // Note that target window name is not the same as target window title
		     // https://stackoverflow.com/questions/8051811/how-to-show-window-title-using-window-open
		     window.open(url, target);	             
		  } else {
		     window.open(url, '_blank');
		  }
		} else if (actionName == "javaToWebswingJSConsoleLog") {
		    console.log("Got message from java:\n" + data);
		}
	    
	      }
            }

	    
       }
       };
       
      
       // The applet jar files can just remain in web/applet where they are compiled up
       
       if(!webswingInstance0.options.args) {
          webswingInstance0.options.args="";       
       }

       var verbosity = 3;
       
       // Fill up webswingParams JSON record with fallbacks for non-dynamic values
       // and values that are not user configurable
       var webswingParams = {
       //"webswing":1, // set in webswing.config.in to discourage editing
       "verbosity": verbosity,       
       "imageMustNotHave":"interfaces/",
       "imageType":".jpg%.png",
       "maxDepth": 500,
       "maxDisplay": 25,
       "refreshDelay": 1500,
       "isJava2":"auto",
       "bgcolor":"#96c29a"
       };
       
       
       // get all available webswing config settings from gsf variables set in classifier.xsl
       for (var webswingParam of Object.keys(webswingParams)) {         
	  if(gs.variables[webswingParam]) { // if this exists as a gsf variable name
	     webswingParams[webswingParam] = gs.variables[webswingParam];
	  } else {
	     if(verbosity>=4) {
	        console.log("User configuration in pageResponse did not supply: " + webswingParam + ". Using fallback: " + webswingParams[webswingParam]);
	     }
	  }
       }
	  
       // Setting the dynamic arguments to be passed to the webswing app       
       //https://stackoverflow.com/questions/25203124/how-to-get-base-url-with-jquery-or-javascript
       var baseURL;
       if(gs.requestInformation.baseURL) {
          baseURL = window.location.protocol + gs.requestInformation.baseURL; // contains servlet
       } else { // will this else block ever again need to be used?
          baseURL = window.location.origin+window.location.pathname;       
          // webswingInstance0.options.args += "\"" + baseURL+ "?a=a&amp;rt=d&amp;s=GsdlCollageApplet&amp;c=smallbea\"";
          var servlet_index = baseURL.indexOf("/"+gs.xsltParams.library_name);
          if(servlet_index > 0) {
             baseURL = baseURL.substring(0, servlet_index+1);
	  }
       }
       
       //var gs3CollImgPath = gs.xsltParams.library_name + "/sites/" + gs.xsltParams.site_name + "/collect/" + gs.cgiParams.c;
       var gs3CollBrowsePath = gs.xsltParams.library_name + "/collection/" + gs.cgiParams.c + "/browse/" + gs.cgiParams.cl; // cl is classifier, e.g "CL3"
       
       webswingParams["gsdlversion"] = 3,
       webswingParams["baseurl"] = baseURL;
       webswingParams["collection"] = gs.cgiParams.c;
       webswingParams["library"] = gs.xsltParams.library_name;
       webswingParams["documentroot"] = gs.xsltParams.servlet_context;
       webswingParams["hrefMustHave"] = gs3CollBrowsePath;
       webswingParams["classifier"] = gs.cgiParams.cl + ".1";

       // So our JavaScript logging here obeys any user-supplied verbosity:
       verbosity = webswingParams["verbosity"]; 
    
       // Special case: width and height are attributes of the applet tag not subelements
       // and may need parsing.
       // Control the width and height of the Java application launched with webswing by
       // passing the width and height params set on the webswing element, unless an applet
       // element is available. In that case try to get the dimensions from the applet tag.
       // https://stackoverflow.com/questions/21851633/get-height-from-style-attribute
       var w = gs.variables["collagewidth"] ? gs.variables["collagewidth"] : document.getElementById("webswing-collage").style.width;
       var h = gs.variables["collageheight"] ? gs.variables["collageheight"] : document.getElementById("webswing-collage").style.height;
       webswingParams["width"] = stripUnitOffAttribute("px", w);
       webswingParams["height"] = stripUnitOffAttribute("px", h);

       // Webswing only uses the width and height set on the webswing-collage element
       // Override this with any dimensions set on any applet element, as that is user-controlled
       // from GLI. style.setProperty failed without the 'important' param to force the setting.
       // https://stackoverflow.com/questions/5191478/changing-element-style-attribute-dynamically-using-javascript
       document.getElementById("webswing-collage").style.setProperty("width", webswingParams["width"] + "px", "important");
       document.getElementById("webswing-collage").style.setProperty("height", webswingParams["height"] + "px", "important");

       if(verbosity >= 4) {
          console.log("@@@ Final verbosity: " + webswingParams["verbosity"]
            + ", width: " + webswingParams["width"] + ", height: " + webswingParams["height"]);
       }
       // Having collected all the webswingParams, we can finally build up the single webswing customArgs string
       var _args = "";
       for (var webswingParam of Object.keys(webswingParams)) {
          _args += "--" + webswingParam + " \"" + webswingParams[webswingParam] + "\" "; // space at end to precede next arg
       }
       webswingInstance0.options.args += _args.substring(0, _args.length-1); // remove extra space at end
   
       
       // Set this to false if running the webswing instance as a webswing application. This has
       // nothing to do with if the applet element exists on the page: it can be on the page
       // and you can still decide to run GsdlCollage as a webswing application. If switching
       // between running as application and applet, remember to adjust webswing.config.in
       // Either way, since we still push the deprecated applet element onto the page, we can use
       // it as a shim: use JavaScript to read its configuration params and pass them to webswing.

       var isWebswingRunAsApplet = true;

       // When run as webswing applet (instead of as webswing application), the webswing var
       // customargs becomes assigned as the value of key "xtraParams" in webswing.config.in
       // and is a string of key-value pairs. And our Java code is able to successfully
       // receive these key-valye pairs in the form k1::v1;;k2::v2;; (URL form of key-value
       // pairs is not easy to pass in from JavaScript through webswing into Java).

       if(isWebswingRunAsApplet) {
          var xtraParams = webswingInstance0.options.args;
          var hyphens_index = xtraParams.indexOf("--");
          var spaceAfterKey = -1;
          while(hyphens_index >= 0) {
             // Locate start of value in each key-value pair
             spaceAfterKey = xtraParams.indexOf(" ", hyphens_index);
	     if(spaceAfterKey >= 0) {
	        // insert (splice in) the key-value internal separator,creating "key::value"
                xtraParams = [xtraParams.slice(0, spaceAfterKey), "::", xtraParams.slice(spaceAfterKey+1)].join('');
	     }
	     hyphens_index = xtraParams.indexOf("--", hyphens_index+2);
          }
          // now add separator *between* each key-value pairs with ;;
          xtraParams = xtraParams.replaceAll(" --", ";;");
          webswingInstance0.options.args = xtraParams.substring(2);
       }

       if(verbosity >= 4) {
          console.log("args: " +  webswingInstance0.options.args);
       }

    function getParam(name) {
        name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
        var results = new RegExp("[\\?&amp;]" + name + "=([^&amp;#]*)").exec(location.href);
        return results == null ? null : decodeURIComponent(results[1]);
    }

    function stripUnitOffAttribute(unit, attr) {
    // common code, regardless of whether we use the applet element as a shim or not
       var suffixIndex = 0;
       if(attr) {       
          suffixIndex = attr.indexOf(unit);
          if(suffixIndex>0) {
             attr = attr.substring(0, suffixIndex);
          }
       }       
       return attr;
    }
  </gsf:script>

	  
  <script data-webswing-global-var="webswing">
    <xsl:text disable-output-escaping="yes">
      var unloaded = false;
      
    (function (window, document) {
        var loader = function () {

	    unloaded = false; // reset state, because we are reloading the webswing app
	
	    var baseUrl = '/' + gs.xsltParams.webswing_context +'/collage';
            baseUrl = baseUrl.indexOf("/", baseUrl.length - 1) !== -1 ? baseUrl : (baseUrl + "/");
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function () {
                if (xmlhttp.readyState == XMLHttpRequest.DONE) {
                    var version = xmlhttp.status == 200 ? xmlhttp.responseText : "undefined";
                    var script = document.createElement("script"),
                        tag = document.getElementsByTagName("script")[0];
                    script.src = baseUrl + "javascript/webswing-embed.js?version=" + version;
                    tag.parentNode.insertBefore(script, tag);
		    
		    if (xmlhttp.status != 200) { // possibly no webswing-server
		      document.getElementById("webswing-collage").style.setProperty("display", "none", "important");

		      document.getElementById("collage-displaying-info").style.setProperty("display", "block", "important");
		      document.getElementById("collage-displaying-info").textContent += " cannot be displayed as the webswing extension it requires has possibly been deactivated.";		      
		    }
                }
            };
            xmlhttp.open("GET", baseUrl + "rest/version", true);
            xmlhttp.send();
        };

	var navigatingAway = function () {
	   if(verbosity >= 4) {
	      console.log("*** navigatingAway called");
	   }
	      
	   // Multiple eventlisteners are registered to call navigatingAway, as not all are 
	   // triggered in all contexts (desktop vs mobile vs older browsers)
	   // https://developer.mozilla.org/en-US/docs/Web/API/Window/unload_event
	   // We work with multiple eventlisteners to ensure we cleanup webswing collage app when
	   // user navigates away from page. But we should only do the cleanup once, even if *all*
	   // event handlers got triggered. We use the unloaded var to ensure we cleanup only once
	   if(!unloaded) {

	      // Sadly, sending messages to Java from JavaScript using the webswing API does not
	      // work for us.
	      // So we do not succeed in calling our handler in Java for our custom action
	      // navigatingAway or even testJavaCall, like this (Java does not get the message):
	      //
	      // if(typeof webswingInstance0.setControl === 'function') {
	      //   Allow sending user events to swing application
	      //   https://www.webswing.org/docs/20.2/integrate/embed.html
	      //   webswingInstance0.setControl(true);
	      //
	      //   console.log("@@@ Asking webswing to stop the collage application");
	      //   webswingInstance0.performAction({actionName: "navigatingAway"});
	      ///  webswingInstance0.performAction({actionName: "testJavaCall"});
	      //   // unload only once even if multiple listeners call navigatingAway() callback
	      //   unloaded = true;
	      // }
	      //
	      // Fortunately the official webswing kill() function on the webswing
	      // instance is successfully sent and detected on the Java end.
	      // In fact, the behaviour on kill() is a little more complicated:
	      // kill() is able to stop the GsdlCollageApplet when collage runs as an
	      // application, because the default webswing behaviour is to generate a
	      // WindowClosing event, which GsdlCollage is written to respond to when run as an
	      // application).
	      // When GsdlCollageApplet is run as an applet, it cannot detect and respond to
	      // the regular WindowClosing event and the Java end needs to implement the webswing
	      // shutdown-handler to cleanly stop and exit.
	      
	      if(typeof webswingInstance0.kill === 'function') { // it should exist
	         if(verbosity >= 3) {
	            console.log("@@@ Telling webswing to stop the collage application/applet");
		 }
		 webswingInstance0.kill();
		 unloaded = true; // do not unload again, if multiple listeners call navigatingAway() callback function
		 if(verbosity >= 4) {
		    console.log("@@@@ unloaded");
		 }
	      } // else cannot call method that does not exist
	   } else {
	      if(verbosity >= 4) {   
	         console.log("@@@@ already unloaded.");
	      }
	   }
	  
	};
	window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload", loader);


	// When the user navigates away from this page or reloads it, we want to
	// shutdown the webswing Java application/applet.	
	
	// https://developer.mozilla.org/en-US/docs/Web/API/Window/unload_event
	// unload is discouraged as it is not always supported (some mobile devices),
	// so we listen for pagehide events too. Visibilitychange events happen on minimising the
	// window or another tab getting focus. So do not stop the app on mere visibilitychange.
	// https://dev.to/amersikira/top-3-ways-to-easily-detect-when-a-user-leaves-a-page-using-javascript-2ce4
	
	// Pagehide is also fired when user presses back button: https://developer.mozilla.org/en-US/docs/Web/API/Window/pagehide_event
	// https://stackoverflow.com/questions/15925251/trigger-an-event-when-user-navigates-away
	
	// Order of registering listeners may matter and be useful:
	// https://stackoverflow.com/questions/31852179/javascript-event-listeners-firing-order
	// https://stackoverflow.com/questions/2706109/are-javascript-dom-event-handlers-called-in-order-of-registration
	// https://medium.com/@olofbaage/javascript-essentials-all-you-need-to-know-about-event-listeners-8ed889bffb8d
	// Event support detection
	// https://stackoverflow.com/questions/158673/onbeforeunload-support-detection
	// https://stackoverflow.com/questions/2877393/detecting-support-for-a-given-javascript-event
	// http://perfectionkills.com/detecting-event-support-without-browser-sniffing

	// Does onUnload not leave enough time to get webswing to shutdown? OnBeforeUnload works
	// https://caniuse.com/?search=beforeunload
	
	window.addEventListener ? window.addEventListener("beforeunload", navigatingAway, false) : window.attachEvent("onbeforeunload", navigatingAway);
	window.addEventListener ? window.addEventListener("pagehide", navigatingAway, false) : window.attachEvent("onpagehide", navigatingAway);
	//window.addEventListener ? window.addEventListener("visibilitychange", navigatingAway, false) : window.attachEvent("onvisibilitychange", navigatingAway);	
	
	})(window, document);
    </xsl:text>
  </script>

  </xsl:template>

    <xsl:template name="get-collage-settings">
    <!-- Creates gsf variables (which sets XSL and JavaScript vars) for any user configured
	 Collage Classifier options coming through collectionConfig and then buildConfig,
	 so that JavaScript can pass them to the webswing instance on starting it up. -->
    <xsl:choose>
        <xsl:when test="option[@name='geometry']/@value">
	  <gsf:variable name="collagewidth">
	    <xsl:value-of select="substring-before(option[@name='geometry']/@value, 'x')" />
	  </gsf:variable>
	  <gsf:variable name="collageheight">
	    <xsl:value-of select="substring-after(option[@name='geometry']/@value, 'x')" />
	  </gsf:variable>
	</xsl:when>
    </xsl:choose>
    
    <xsl:choose>
      <xsl:when test="option[@name='verbosity']/@value">
	<gsf:variable name="verbosity">
	  <xsl:value-of select="option[@name='verbosity']/@value"/>
	</gsf:variable>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="option[@name='imageMustNotHave']/@value">
	<gsf:variable name="imageMustNotHave">
	  <xsl:value-of select="option[@name='imageMustNotHave']/@value"/>
	</gsf:variable>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="option[@name='imageType']/@value">
	<gsf:variable name="imageType">
	  <xsl:value-of select="option[@name='imageType']/@value"/>
	</gsf:variable>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="option[@name='maxDepth']/@value">
	<gsf:variable name="maxDepth">
	  <xsl:value-of select="option[@name='maxDepth']/@value"/>
	</gsf:variable>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="option[@name='maxDisplay']/@value">
	<gsf:variable name="maxDisplay">
	  <xsl:value-of select="option[@name='maxDisplay']/@value"/>
	</gsf:variable>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="option[@name='refreshDelay']/@value">
	<gsf:variable name="refreshDelay">
	  <xsl:value-of select="option[@name='refreshDelay']/@value"/>
	</gsf:variable>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="option[@name='isJava2']/@value">
	<gsf:variable name="isJava2">
	  <xsl:value-of select="option[@name='isJava2']/@value"/>
	</gsf:variable>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="option[@name='bgcolor']/@value">
	<gsf:variable name="bgcolor">
	  <xsl:value-of select="option[@name='bgcolor']/@value"/>
	</gsf:variable>
      </xsl:when>
    </xsl:choose>
    
    <!-- 
	 Defaults to fall back on when there is no user customisation
	 can be manually adjusted here. -->
    <!--    
    <xsl:call-template name="set-collage-gsfvar-if-exists">
      <xsl:with-param name="varName">imageMustNotHave</xsl:with-param>
    </xsl:call-template>    
    <xsl:call-template name="set-collage-gsfvar-if-exists">
      <xsl:with-param name="varName">imageType</xsl:with-param>
    </xsl:call-template>    
    <xsl:call-template name="set-collage-gsfvar-if-exists">
      <xsl:with-param name="varName">verbosity</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="set-collage-gsfvar-if-exists">
      <xsl:with-param name="varName">maxDepth</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="set-collage-gsfvar-if-exists">
      <xsl:with-param name="varName">maxDisplay</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="set-collage-gsfvar-if-exists">
      <xsl:with-param name="varName">refreshDelay</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="set-collage-gsfvar-if-exists">
      <xsl:with-param name="varName">isJava2</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="set-collage-gsfvar-if-exists">
      <xsl:with-param name="varName">bgcolor</xsl:with-param>
    </xsl:call-template>
    -->   
  </xsl:template>

  <!-- Doesn't work -->
  <!-- https://our.umbraco.com/forum/developers/xslt/9274-Return-Value-from-a-Template -->
  <!--<xsl:value-of select="$varName"/>-->
  <!--<xsl:attribute name="name"><xsl:value-of select="$varName" /></xsl:attribute>-->
  <!--
  <xsl:template name="set-collage-gsfvar-if-exists">
    <xsl:param name="varName" />

    <xsl:choose>
      <xsl:when test="option[@name=$varName]/@value">
	<gsf:variable name="$varName">
	  
	  <xsl:value-of select="option[@name=$varName]/@value"/>
	</gsf:variable>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  -->
</xsl:stylesheet>
