<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:java="http://xml.apache.org/xslt/java"
	xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
	xmlns:gslib="http://www.greenstone.org/skinning"
	extension-element-prefixes="java util"
	exclude-result-prefixes="java util gsf">

	<!-- use the 'main' layout -->
	<xsl:import href="layouts/main.xsl"/>
	
	<!-- set page title -->
	<xsl:template name="pageTitle"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'db.doc_basket')"/></xsl:template>
	
	<!-- set page breadcrumbs -->
	<xsl:template name="breadcrumbs"><gslib:siteLink/><gslib:rightArrow/> 
	<gslib:collectionNameLinked/><gslib:rightArrow/></xsl:template>

	<xsl:template name="init-seaweed"/>
	
	<!-- the page content -->
	<xsl:template match="/page">
		<!-- Make sure the user is allowed to use this functionality -->
		<xsl:choose>
			<xsl:when test="util:equals(util:getGlobalProperty('disable.collection.building'),'false') and /page/pageRequest/userInformation and util:canEditCollection(/page/pageRequest/userInformation/@username,/page/pageRequest/userInformation/@groups, $collNameChecked)">
				<script type="text/javascript" src="interfaces/{$interface_name}/js/documentmaker_scripts.js"><xsl:text> </xsl:text></script>
				<script type="text/javascript" src="interfaces/{$interface_name}/js/documentmaker_scripts_dd.js"><xsl:text> </xsl:text></script>
				<script type="text/javascript" src="interfaces/{$interface_name}/js/documentedit_scripts_util.js"><xsl:text> </xsl:text></script>
				<script type="text/javascript">YAHOO.util.Event.onDOMReady(initDocumentMaker);</script>

				<link src="interfaces/{$interface_name}/style/documentbasket.js"/>
				<xsl:for-each select="//item">
					<a class="dbdoc">
						<xsl:attribute name="href"><xsl:value-of select="$library_name"/>?a=d&amp;c=<xsl:value-of select="/page/pageResponse/collection/@name"/>&amp;dt=hierarchy&amp;d=<xsl:value-of select="@name"/>&amp;p.a=b&amp;p.s=<xsl:value-of select="/page/pageResponse/service/@name"/>&amp;ed=1</xsl:attribute>
						<xsl:value-of select="@title"/>
					</a>
				</xsl:for-each>
				
				<gslib:langfrag name="dse"/><!--<xsl:call-template name="document-editor-language-fragments"/>-->
			</xsl:when>
			<xsl:otherwise>
				<div>
					<xsl:choose>
						<xsl:when test="util:equals(util:getGlobalProperty('disable.collection.building'),'true')">
							<xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'db.no_collection_building')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'db.access_denied')"/>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>  



