<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:java="http://xml.apache.org/xslt/java"
		xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
		xmlns:gslib="http://www.greenstone.org/skinning"
		xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"
		extension-element-prefixes="java util"
		exclude-result-prefixes="java util">
  
  <!-- use the 'main' layout -->
  <xsl:include href="layouts/main.xsl"/>
  <xsl:variable name="help_interface_name" select="concat('aux_', $interface_name)"/>
  
  <!-- set page title -->
  <xsl:template name="pageTitle"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'help_b')"/></xsl:template>

  <!-- set page breadcrumbs -->
  <xsl:template name="breadcrumbs">
    <gslib:siteLink/><gslib:rightArrow/>
    <gslib:groupLinks/>
    <xsl:if test="/page/pageResponse/collection">
      <gslib:collectionNameLinked/><gslib:rightArrow/>
    </xsl:if>
  </xsl:template>

  <!-- the page content -->
  <xsl:template match="page">
    <xsl:choose>
      <xsl:when test="/page/pageResponse/collection">
	<xsl:call-template name="collectionHelp"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:call-template name="homePageHelp"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  

  <xsl:template name="homePageHelp">
    <!--<p><i>Under Construction</i></p>
    This page should describe
    <ul>
      <li>Collections and Cross collection search</li>
      <li>global preferences - language</li>
      <li>Registering and logging in</li>
      <li>Administration Page</li>
      <li>links to collection help pages?</li>
      <li>links to wiki for more info</li>
      </ul>-->
    <p><i><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.title')"/></i></p>
    <dl>
      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, /page/@lang, 'home.select_a_collection')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.collection_descr')"/></dd>

      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, /page/@lang, 'login_b')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.login_descr')"/></dd>

      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, /page/@lang, 'help_b')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.help_descr')"/></dd>

      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, /page/@lang, 'pref_b')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.preferences_descr')"/></dd>

      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, /page/@lang, 'home.quick_search')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.quicksearch_descr')"/></dd>

      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.crosscollsearch')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.crosscollsearch_descr')"/></dd>

      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, /page/@lang, 'authen.authentication')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.adminpage_descr')"/></dd>

      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, /page/@lang, 'depositor.title')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.depositor_descr')"/></dd>

      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, /page/@lang, 'authen.register')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.register_descr')"/></dd>

      <dt><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($interface_name, /page/@lang, 'gsdl.title')"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.general.aboutgreenstone_descr')"/></dd>
      
    </dl>
  </xsl:template>
  
  <xsl:template name="collectionHelp">
    <!-- Using the {0} collection -->
    <h2><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.collection_title', $collName)"/></h2>

    <!-- link to general help page -->
    <p><i><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.link_to_main', concat($library_name,'/page/help;', $library_name, '/page/gsdl'))"/></i></p>
    <!-- general intro text -->
    <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.collection_general')"/></p>

    <xsl:call-template name="browsingHelp"/>
    <xsl:if test="/page/pageResponse/collection/serviceList/service[@type='query']">
      <xsl:call-template name="searchingHelp"/>
      <xsl:call-template name="searchParamsHelp"/>
      <xsl:call-template name="searchResultsHelp"/>
    </xsl:if>
    <xsl:call-template name="documentHelp"/>
    <xsl:if test="$favouritebasket = 'true'">
       <xsl:call-template name="favouriteBasketHelp"/>
    </xsl:if>
     <xsl:if test="//format/gsf:option[@name='RSS']/@value= 'true'">
      <xsl:call-template name="rssHelp"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="browsingHelp">
    <h3><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.browsing_title')"/></h3><br/>
    <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.browsing_general')"/></p>
    <dl>
      <dt><img src="interfaces/{$interface_name}/images/bshelf.gif"/></dt>
      <xsl:variable name="plus_icon"><img src="interfaces/{$interface_name}/images/expand.png"/></xsl:variable>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceTextWithDOM($help_interface_name, /page/@lang, 'help.browsing_bookshelf', $plus_icon)"/></dd>
      <xsl:variable name="book_icon"><img src="interfaces/{$interface_name}/images/book.png"/></xsl:variable>
      <xsl:variable name="page_icon"><img src="interfaces/{$interface_name}/images/itext.gif"/> </xsl:variable>
      <dt><xsl:copy-of select="$book_icon"/><gsf:space/> <xsl:copy-of select="$page_icon"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceTextWithDOM($help_interface_name, /page/@lang, 'help.browsing_book', $book_icon, $page_icon)"/></dd>
       <dt><img src="interfaces/{$interface_name}/images/ipdf.gif"/><gsf:space/><img src="interfaces/{$interface_name}/images/imsword.gif"/><gsf:space/><img src="interfaces/{$interface_name}/images/imp3.gif"/> ...</dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.browsing_srcicon')"/></dd>
      </dl>
  </xsl:template>

  <xsl:template name="searchingHelp">
    <h3><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searching_title')"/></h3><br/>
    <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searching_quick')"/></p>
    <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searching_more')"/></p>
    <dl>
      <xsl:for-each select="/page/pageResponse/collection/serviceList/service[@type='query']">
	<xsl:variable name="qname"><xsl:value-of select="@name"/></xsl:variable>
      <dt><xsl:value-of select="displayItem[@name='name']"/></dt>
      <dd><xsl:choose><xsl:when test="@name='TextQuery'"><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searching_text')"/></xsl:when>
      <xsl:when test="@name='FieldQuery'"><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searching_form')"/></xsl:when>
      <xsl:when test="@name='AdvancedFieldQuery'"><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searching_adv')"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@name"/></xsl:otherwise>
    </xsl:choose>
    </dd>
      </xsl:for-each>
    </dl>
  </xsl:template>
  <xsl:template name="searchParamsHelp">
       <h3><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searchparams_title')"/></h3><br/>
       <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searchparams_general')"/></p>
       <ul>
    <xsl:for-each select="/page/pageResponse/collection/serviceList/service[@type='query']/paramList/param[@type != 'invisible' and @type != 'enum_multi' and @type != 'multi' and not(@name=preceding::param/@name)]">
      <xsl:variable name="pname">help.sp_<xsl:value-of select="@name"/></xsl:variable>
      <li><b><xsl:value-of select="displayItem[@name='name']"/>: </b><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, $pname)"/></li>
    </xsl:for-each>
    <xsl:if test="not(/page/pageResponse/collection/serviceList/service[@type='query']/paramList/param[@name='hitsPerPage'])">
      <li><b><xsl:value-of disable-output-escaping="yes" select="util:getGenericText('ServiceRack', /page/@lang, 'param.hitsPerPage')"/>: </b><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.sp_hitsPerPage')"/></li>
    </xsl:if>
       </ul>
  </xsl:template>
  <xsl:template name="searchResultsHelp">
    <h3><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searchresults_title')"/></h3><br/>
    <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searchresults_general')"/></p>
    <xsl:if test="/page/pageResponse/collection/serviceList/service[@type='query']/metadataList/metadata[@name='does_facetsearch']/@value='true'">
      <h4><b><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searchresults_facet_title')"/></b></h4>
      <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.searchresults_facets')"/></p>
    </xsl:if>
    <br/>
  </xsl:template>

  <xsl:template name="documentHelp">
    <h3><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.document_title')"/></h3><br/>
    <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.document_general')"/></p>
    <h4><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.document_toc_title')"/></h4>
    <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.document_toc')"/></p>
    <h4><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.document_icons')"/></h4>
    <dl>
      <dt><img src="interfaces/{$interface_name}/images/hl.png"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.document_highlight')"/></dd>
      <dt><img src="interfaces/{$interface_name}/images/floattoc.png"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.document_floattoc')"/></dd>
      <dt><img src="interfaces/{$interface_name}/images/zoom.png"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.document_zoomer')"/></dd>
      <dt><img src="interfaces/{$interface_name}/images/slideshow.png"/></dt>
      <dd><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.document_slideshow')"/></dd>
	
    </dl>
    <br/>
  </xsl:template>
  
  <xsl:template name="favouriteBasketHelp">
    <xsl:variable name="fav_icon"><img src="interfaces/{$interface_name}/images/favourite-star-transparent-unselected32.png" width="16" height="16"/></xsl:variable>
    <xsl:variable name="fav_icon_selected"><img src="interfaces/{$interface_name}/images/favourite-star-transparent-selected32.png" width="16" height="16"/></xsl:variable>
    <h3><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.favourites_title')"/></h3><br/>
    <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceTextWithDOM($help_interface_name, /page/@lang, 'help.favourites', $fav_icon, $fav_icon_selected)"/></p>
    <br/>
  </xsl:template>
  
  <xsl:template name="rssHelp">
    <xsl:variable name="rss_icon"><img src="interfaces/{$interface_name}/images/rssicon.png"/></xsl:variable>
    <h3><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceText($help_interface_name, /page/@lang, 'help.rss_title')"/></h3><br/>
    <p><xsl:value-of disable-output-escaping="yes" select="util:getInterfaceTextWithDOM($help_interface_name, /page/@lang, 'help.rss', $rss_icon)"/></p>
    <br/>
  </xsl:template>

 
</xsl:stylesheet>
