<?xml version="1.0" encoding="UTF-8"?>
<!-- this page is used when the user clicks the Login button. If they have been directed to Login by trying to access a restricted page when they are not already logged in, then they will go to the Login section of authen.xsl -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:java="http://xml.apache.org/xslt/java"
	xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
	xmlns:gslib="http://www.greenstone.org/skinning"
	xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"
	extension-element-prefixes="java util"
	exclude-result-prefixes="java util">

	<!-- use the 'main' layout -->
	<xsl:import href="layouts/main.xsl"/>

	<!-- set page title -->
	<xsl:template name="pageTitle"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'login_b')"/></xsl:template>

	<!-- set page breadcrumbs -->
	<xsl:template name="breadcrumbs"><gslib:siteLink/></xsl:template>

	<!-- the page content -->
	<xsl:template match="/page">
	  <gsf:style>
	    <xsl:text disable-output-escaping="yes">
	    /* Based on: https://stackoverflow.com/questions/2812770/add-centered-text-to-the-middle-of-a-horizontal-rule */
.hr-with-text {
  display: flex;
  align-items: center;
  text-align: center;
}

.hr-with-text::before,
.hr-with-text::after {
  content: '';
  flex: 1;
  border-bottom: 1px solid #000;
}

.hr-with-text:not(:empty)::before {
  margin-right: .25em;
}

.hr-with-text:not(:empty)::after {
  margin-left: .25em;
}


input.gsloginform[type=submit] {
    float: right;
    margin-right: 3px;
    margin-top: 5px;
    width: 80px;
    height: 30px;
}
  
            </xsl:text>
	  </gsf:style>

		<gsf:variable name="loginErrorMessage"><xsl:value-of select="/page/pageRequest/paramList/param[@name = 'loginMessage']/@value"/></gsf:variable>

		<!--
		<xsl:if test="/page/pageRequest/paramList/param[@name = 'loginMessage']/@value">
		-->
		<xsl:if test="$loginErrorMessage != ''">
		  <div id="gs_error" class="ui-state-error ui-corner-all">
		    <span class="ui-icon ui-icon-alert" style="float: left;">
		      <xsl:text> </xsl:text>
		    </span>
		    <xsl:value-of select="$loginErrorMessage"/>
		  </div>
		<br/>
		</xsl:if>
		<xsl:call-template name="loginForm">
                  <xsl:with-param name="action-url" select="/page/pageRequest/paramList/param[@name = 'redirectURL']/@value" /> 
		  <!-- <xsl:with-param name="action-url"><xsl:value-of  select="$library_name"/><xsl:text>?el=direct&amp;rl=2</xsl:text></xsl:with-param> -->
                </xsl:call-template>
	</xsl:template>
</xsl:stylesheet>
