<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"
		xmlns:gslib="http://www.greenstone.org/XSL/Library">	
	
	<xsl:template name="coll-description">
	  <p><gsf:collectionText name="description1a" propertyFile="collectionConfig"/></p>
	  
	  <gsf:collectionText name="description1" propertyFile="collectionConfig"/>
	  <gsf:collectionText name="description1b" propertyFile="collectionConfig"/>
	  <gsf:collectionText name="description2" propertyFile="collectionConfig"/>
	  
	  <pre>
  &lt;xsl:template name="additionalHeaderContent-collection"&gt; 
    &lt;xsl:variable name="httpCollection"&gt; 
      &lt;xsl:value-of select="/page/pageResponse/collection/metadataList/metadata[@name='httpPath']"/&gt; 
    &lt;/xsl:variable&gt; 
	&lt;link rel="stylesheet" href="{$httpCollection}/style/gs3-style-default-extra.css" type="text/css"  
	   title="GS3 Style" id="custom-style" charset="UTF-8"/&gt; 
	&lt;script src="{$httpCollection}/script/custom-script.js" type="text/javascript"&gt; 
	&lt;/script&gt; 
  &lt;/xsl:template&gt; 
 
  &lt;xsl:template name="create-banner"&gt;   
	&lt;div class="choose_style"&gt; 
		Choose a style: 
		&lt;a href="#" onclick="replaceStyle('gs3-style-default-extra');return false;"&gt;Default Greenstone&lt;/a&gt;, 
		&lt;a href="#" onclick="replaceStyle('gs3-style-blue');return false;"&gt;Blue&lt;/a&gt;, 
		&lt;a href="#" onclick="replaceStyle('gs3-style-olive-purple');return false;"&gt;OlivePurple&lt;/a&gt;,		 
		&lt;a href="#" onclick="replaceStyle('');return false;"&gt;None&lt;/a&gt; 
		&lt;/div&gt; 
    &lt;div id="gs_banner" class="ui-widget-header ui-corner-bottom"&gt;	     
      &lt;div id="titlesearchcontainer"&gt; 
	&lt;xsl:call-template name="page-title-area"/&gt;	 
	&lt;xsl:call-template name="quick-search-area"/&gt; 
	&lt;div style="clear:both;"&gt;&lt;xsl:text&gt; &lt;/xsl:text&gt;&lt;/div&gt;	 
      &lt;/div&gt; 
      &lt;xsl:call-template name="browsing-tabs"/&gt;	 
    &lt;/div&gt; 
  &lt;/xsl:template&gt; 
</pre> 


      <p><gsf:collectionText name="description3" propertyFile="collectionConfig"/>
      <ul>
	<li><a href='https://trac.greenstone.org/browser/documented-examples/trunk/style-e/style/gs3-style-default-extra.css'><gsf:collectionText name="style.extra" propertyFile="collectionConfig"/></a> - <gsf:collectionText name="description3a" propertyFile="collectionConfig"/></li> 
	<li><a href='https://trac.greenstone.org/browser/documented-examples/trunk/style-e/style/gs3-style-blue.css'><gsf:collectionText name="style.blue" propertyFile="collectionConfig"/></a> - <gsf:collectionText name="description3b" propertyFile="collectionConfig"/></li> 
	<li><a href='https://trac.greenstone.org/browser/documented-examples/trunk/style-e/style/gs3-style-olive-purple.css'><gsf:collectionText name="style.olive" propertyFile="collectionConfig"/></a> - <gsf:collectionText name="description3c" propertyFile="collectionConfig"/></li> 
	<li><gsf:collectionText name="style.none" propertyFile="collectionConfig"/> - <gsf:collectionText name="description3d" propertyFile="collectionConfig"/></li> 
      </ul> 
      </p>

      <p><b><gsf:collectionText name="description4" propertyFile="collectionConfig"/></b>
<ul>
<li><gsf:collectionText name="description4a" propertyFile="collectionConfig"/></li>
<li><gsf:collectionText name="description4b" propertyFile="collectionConfig"/>
<pre>
&lt;xsl:template name="additionalHeaderContent"&gt;
    &lt;xsl:variable name="httpCollection"&gt; 
      &lt;xsl:value-of select="/page/pageResponse/collection/metadataList/metadata[@name='httpPath']"/&gt;
    &lt;/xsl:variable&gt; 
    &lt;link href="{$httpCollection}/style/stylesheet-name.css" rel="stylesheet" type="text/css"/&gt;
&lt;/xsl:template&gt;</pre>
</li>
</ul>
</p>


	  <xsl:call-template name="listCollFiles">
	    <xsl:with-param name="file_list">etc/collectionConfig.xml;transform/layouts/header.xsl;script/custom-script.js</xsl:with-param>
	  </xsl:call-template>
	</xsl:template>

</xsl:stylesheet>  

