package org.greenstone.gatherer.feedback;

import java.awt.*;
import java.applet.Applet;
import java.awt.image.*;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowAdapter;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.geom.GeneralPath;
import java.io.*;
import javax.imageio.*;
import javax.swing.*; 
import java.awt.geom.*;

/**
 * This class can take screen shot of the whole screen size or screen shot of a specified
 * rectangle only.
 * @author Veronica Liesaputra
 */
public class ScreenShot
{
    /**
     * This is the buffered image that hold the screen shot.
     */
    private BufferedImage img;
    
    /**
     * The dimension of the whole screen size.
     */
    private final static Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    
    /**
     * Rectangle with a dimension of a whole screen size.
     */
    private Rectangle mRect = new Rectangle(dim);
    
    /**
     * The desired width of the image.
     */
    private int iw;

    /**
     * The desired height of the image.
     */
    private int ih;

    /**
     * BufferedImage that hold the screen shot image with the desired height and width.
     */
    private BufferedImage bi;
    
    /**
     * This is the robot that allows to take screen shot.
     */
    private Robot mRobot;
  
    /**
     * This constructor will setup the robot to alow taking a screen shot.
     */
    public ScreenShot () 
    {
	try
	    {
		mRobot = new Robot();
		iw = (int) (dim.getWidth() - 60);
		ih = (int) (dim.getHeight() * 0.75) - 50;
	    }
	catch (AWTException exp) {}
    }

    /**
     * This method will only take screen shot of the particular rectangle.
     * @param rect is the specified rectangle that we want to take the screen shot of.
     * @return     the image taken.
     */
    //public byte[] getImageIcon (Rectangle rect)
    public BufferedImage getImageIcon (Rectangle rect)
    {
	BufferedImage image;
	image = null;
	
	//try
	//  {
		img = mRobot.createScreenCapture(rect);
		
		int w,h;
		boolean rescale;

		rescale = false;
		w = rect.width;
		
		if (w >= iw)
		    {
			w = iw - 50;
			rescale = true;
		    }
		
		h = rect.height;
		
		if ( h >= ih)
		    {
			h = ih  - 50;
			rescale = true;
		    }
		
		Graphics2D big;
		big = null;
		
		if (rescale == true)
		    {
			image = new BufferedImage(w,h, BufferedImage.TYPE_INT_RGB);
			big = image.createGraphics();
			big.drawImage(img.getScaledInstance(w,h,Image.SCALE_SMOOTH),0,0,null);
		    }
		else
		    {
			image = img;
		    }

		
		/*ByteArrayOutputStream stream;
		stream = new ByteArrayOutputStream();
		ImageIO.write(image,"jpeg",stream);
		byte[] bytes;
		bytes = stream.toByteArray();*/
		
		if (big != null)
		    big.dispose();
		//image = null;
		//img = null;
		ActionRecorderDialog.setSavefinish(true);
		return image;
		//return bytes;
		//  }
		//catch(IOException ex) {ex.printStackTrace();}
	
	//return null;
    }

    /**
     * This method will only take screen shot of the particular rectangle and encode
     * the image to its string representation.
     * @param rect is the specified rectangle that we want to take the screen shot of.
     * @return     the string representation of the image taken.
     */
    public String getImage (Rectangle rect)
    {
	String txt;
	txt = null;

	BufferedImage image;
	image = null;
	
	try
	    {
		img = mRobot.createScreenCapture(rect);
		
		int w,h;
		boolean rescale;

		rescale = false;
		w = rect.width;
		
		if (w >= iw)
		    {
			w = iw - 50;
			rescale = true;
		    }
		
		h = rect.height;
		
		if ( h >= ih)
		    {
			h = ih  - 50;
			rescale = true;
		    }
	
		Graphics2D big;
		big = null;

		if (rescale == true)
		    {
			image = new BufferedImage(w,h, BufferedImage.TYPE_INT_RGB);
			big = image.createGraphics();
			big.drawImage(img.getScaledInstance(w,h,Image.SCALE_SMOOTH),0,0,null);
		    }
		else
		    {
			image = img;
		    }

		ByteArrayOutputStream stream;
		stream = new ByteArrayOutputStream();
		ImageIO.write(image,"gif",stream);
		byte[] bytes;
		bytes = stream.toByteArray();
		txt = Base64.encodeBytes(bytes);
		
		bytes = null;
		if (big != null)
		    big.dispose();
		image = null;
		img = null;
	    }
	catch(IOException ex) {ex.printStackTrace();}
	
	ActionRecorderDialog.setSavefinish(true);
	
	return txt;
    }

    /**
     * This method will return the buffered image of the whole screen size screen shot
     * with the desired width and height.
     * @return the buffered image with the desired height and width.
     */
    public BufferedImage getBuffImage()
    {
	return bi;
    }

    /**
     * This method will take screen shot of the whole screen and resize it to the
     * desired width and height.
     */
    public BufferedImage captureScreen()
    {
	img = mRobot.createScreenCapture(mRect);
	
	Graphics2D big;
	bi = new BufferedImage(iw,ih, BufferedImage.TYPE_INT_RGB);
	big = bi.createGraphics();
	big.drawImage(img.getScaledInstance(iw,ih,Image.SCALE_SMOOTH),0,0,null);
	big.dispose();
	big = null;

	return bi;
    }

    /**
     * This method will return the desired width.
     * @return the desired width.
     */
    public int getWidth()
    {
	return iw;
    }

    /**
     * This method will return the desired height.
     * @return the desired height.
     */
    public int getHeight()
    {
	return ih;
    }
}












