#include <cstdlib>
#include <cstring>
#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <sys/stat.h>

using namespace std;
#ifdef WINDOWS
#include <windows.h>
#endif


void replace_all( std::string & str, std::string const & pattern, std::string const & replacement );
int process( string command, bool render );
int process_and_catch_output( string command, string &output );
#ifdef WINDOWS
int regSearch(HKEY hKey, const char* keyName, int searchType, char* foundJavaVer );
#endif


class Jvm {

	// version string. era.major.minor_update. eg: 1.4.2_02
	int era_;
	int major_;
	int minor_;
	int update_;

	string javaHome_;
	bool isJdk_;
	bool healthy_;

	public:
	Jvm();
	~Jvm();

	void setJavaHome( string jh );
	string getJavaHome();
	string getExecutable();
	#ifdef WINDOWS
	string getWinExecutable();
	#endif
	string getVersion();
	bool check();
	bool setVersionFromString( string version );
	int compare( Jvm otherJvm );
	int getEra();
	int getMajor();
	int getMinor();
	int getUpdate();

	bool getIsJre();
	bool getIsJdk();

	private:
	void setVersionFromExeOuput();
	void setIsJdkFromJavacPresence();

};



bool find( Jvm &jvm, bool use_minimum, const Jvm& minimum, bool jreOnly, bool jdeOnly, string phint, string hint, bool verbose );
